function loadBadge(element) {
    document.getElementById("cancel").click();
    var id = element.getAttribute("badge-id");
    AJS.$.ajax({
        url: document.getElementById("context-path").value + "/rest/badge/1.0/badges/" + id,
        type: "GET",
        dataType: "json",
        contentType: "application/json",
        success: function(result){
            AJS.$("#no-badge-selected").hide()
            document.getElementById("dropdown-button-text").innerHTML = result.name;
            document.getElementById("BadgeForm").setAttribute("badge-id", result.id);
            document.getElementById("badge-id-link").innerHTML = result.id;
            document.getElementById("badgesLegend").innerHTML = "Badge - " + result.name;
            var dropdownButtonStatusImage = document.getElementById("dropdown-button-status-image");
            var badgeDropDownLinkImage = document.getElementById(result.id + "-enabledStatusImage");
            var checkImage = document.getElementById("link-check-image").getAttribute("value");
            var errorImage = document.getElementById("link-error-image").getAttribute("value");

            if(result.enabled) {
                dropdownButtonStatusImage.setAttribute("src", checkImage);
                AJS.$("#dropdown-button-status-image").show();
                badgeDropDownLinkImage.setAttribute("src", checkImage);
                document.getElementById("radioButtonTrue").setAttribute("checked", "");
                document.getElementById("radioButtonFalse").removeAttribute("checked");
            } else {
                dropdownButtonStatusImage.setAttribute("src", errorImage);
                AJS.$("#dropdown-button-status-image").show();
                badgeDropDownLinkImage.setAttribute("src", errorImage);
                document.getElementById("radioButtonTrue").removeAttribute("checked");
                document.getElementById("radioButtonFalse").setAttribute("checked", "");
            }

            document.getElementById("name").setAttribute("value", result.name);
            document.getElementById("description").innerHTML = result.description;
            document.getElementById("thresholdBronze").setAttribute("value", result.thresholdBronze);
            document.getElementById("thresholdSilver").setAttribute("value", result.thresholdSilver);
            document.getElementById("thresholdGold").setAttribute("value", result.thresholdGold);
            document.getElementById("currentBronzeImage").setAttribute("src", result.bronzeImage);
            document.getElementById("currentSilverImage").setAttribute("src", result.silverImage);
            document.getElementById("currentGoldImage").setAttribute("src", result.goldImage);
            document.getElementById("currentNeutralImage").setAttribute("src", result.neutralImage);

            if(result.id.includes("custom")) {
                $("#delete-badge").prop('disabled', false);
                $("#delete-badge").removeAttr("title")
            } else {
                $("#delete-badge").prop('disabled', true);
                $("#delete-badge").prop('title', document.getElementById("i18n").getAttribute("i18n-badges-delete-badge-disabled-tooltip"));
            }
        }
    });
    AJS.$("#BadgeForm").show();
}
