$(document).ready(function()
{
    $('#GiveBadgeForm').submit(function (e)
    {
        validateForm(this, event);
    });
});

// global variables
// initialized in validate form
var badge;
var badgeId;
var username;
var actions;
var calcMode;

function validateForm(form, e) {
    e.preventDefault();

    var formData = new FormData(form);
    badge = formData.get('badge');
    badgeId = document.getElementById("GiveBadgeForm").getAttribute("badge-id");
    username = formData.get('receiver');
    actions = formData.get('actions');
    calcMode = formData.get('calcMode');

    if(badgeId == null) {
        AJS.messages.error({
            body: document.getElementById("i18n").getAttribute("i18n-badges-please-select-badge")
        });
        return;
    }

    if(!username) {
        AJS.messages.error({
            body: document.getElementById("i18n").getAttribute("i18n-badges-please-fill-username")
        });
        return;
    }

    var contextPath = document.getElementById("context-path").value;

    AJS.$.ajax({
        url: contextPath + "/rest/badge/1.0/users/validate?calcMode=" + calcMode,
        type: "PUT",
        dataType: "json",
        data: JSON.stringify(
        [
          {
            "username": username,
            "badges": [
              {
                "id": badgeId,
                "count": actions
              }
            ]
          }
        ]),
        contentType: "application/json",
        success: function(result){
            openDialog()
        },
        error: function (result) {
            var errorId = result.responseJSON[0].id;
            if(errorId == "User not found") {
                AJS.messages.error({
                    body: document.getElementById("i18n").getAttribute("i18n-badges-user-not-found").replaceAll("{0}", username)
                });
            }
            if(errorId == "New count invalid") {
                AJS.messages.error({
                    body: document.getElementById("i18n").getAttribute("i18n-badges-count-invalid").replaceAll("{0}", actions)
                });
            }
        }
    });
}

function sendForm() {
    if(badgeId == null) {
        AJS.messages.error({
            body: document.getElementById("i18n").getAttribute("i18n-badges-please-select-badge")
        });
        return;
    }

    if(!username) {
        AJS.messages.error({
            body: document.getElementById("i18n").getAttribute("i18n-badges-please-fill-username")
        });
        return;
    }

    var contextPath = document.getElementById("context-path").value;

    var notification;
    var successMessage;
    if(calcMode == "add") {
        notification = true;
        successMessage = document.getElementById("i18n").getAttribute("i18n-badges-actions-added-to-user").replaceAll("{0}", badge).replaceAll("{1}", username).replaceAll("{2}", actions);
    } else {
        notification = false;
        successMessage = document.getElementById("i18n").getAttribute("i18n-badges-actions-removed-from-user").replaceAll("{0}", badge).replaceAll("{1}", username).replaceAll("{2}", actions);
    }

    AJS.$.ajax({
        url: contextPath + "/rest/badge/1.0/users?notification=" + notification + "&calcMode=" + calcMode,
        type: "PUT",
        dataType: "json",
        data: JSON.stringify(
        [
          {
            "username": username,
            "badges": [
        	  {
                "id": badgeId,
                "count": actions
              }
            ]
          }
        ]),
        contentType: "application/json",
        success: function(result){
            closeDialog()

            var message;
            AJS.messages.success({
                body: successMessage
            });
        },
        error: function (result) {
            closeDialog()

            var errorId = result.responseJSON[0].id;
            if(errorId == "User not found") {
                AJS.messages.error({
                    body: document.getElementById("i18n").getAttribute("i18n-badges-user-not-found").replaceAll("{0}", username)
                });
            }
            if(errorId == "Count invalid") {
                AJS.messages.error({
                    body: document.getElementById("i18n").getAttribute("i18n-badges-count-invalid").replaceAll("{0}", actions)
                });
            }
            if(errorId == "Badge not found") {
                AJS.messages.error({
                    body: document.getElementById("i18n").getAttribute("i18n-badges-badge-not-found").replaceAll("{0}", badge)
                });
            }
        }
    });
}

function setBadgeId(badgeId) {
    document.getElementById("GiveBadgeForm").setAttribute("badge-id", badgeId);
}

function openDialog() {
    document.getElementById("dialog-badge").innerHTML = badge;
    document.getElementById("dialog-username").innerHTML = username;

    AJS.$.ajax({
        url: contextPath + "/rest/badge/1.0/users?username=" + username + "&badgeId=" + badgeId,
        type: "GET",
        contentType: "application/json",
        success: function(result){
            var currentActions
            if(result[0]) {
                currentActions = result[0].badges[0].count;
            } else {
                currentActions = 0;
            }

            document.getElementById("dialog-old-count").innerHTML = currentActions;
            if(calcMode == "add") {
                document.getElementById("dialog-new-count").innerHTML = Number(currentActions) +  Number(actions);
            } else {
                document.getElementById("dialog-new-count").innerHTML = Number(currentActions) - Number(actions);
            }
            AJS.dialog2("#dialog").show()
        },
        error: function (result) {
            document.getElementById("dialog-old-count").innerHTML = "NOT FOUND";
            document.getElementById("dialog-new-count").innerHTML = "COULD NOT BE CALCULATED";
            AJS.dialog2("#dialog").show()
        },
    });
}

function closeDialog() {
    AJS.dialog2("#dialog").hide();
}

