$("form#BadgeForm").submit(function(e) {
    e.preventDefault();
    var isHidden = document.getElementById("save").style.display == "none";
    if(isHidden) {
        sendFormNewBadge(this, e);
    } else {
        sendForm(this, e);
    }
});

function toggle(element) {
    var isChecked = element.hasAttribute("checked");
    if(isChecked) {
        document.getElementById("radioButtonTrue").click();
    } else {
        document.getElementById("radioButtonFalse").click();
    }
}

function cancelMethod(form) {

    // allow canceling for the toggle button
    var i;
    var checked = false;
    for (i = 0; i < form.length; i++) {
        if(form[i].id == "enabled-input") {
            if(document.getElementById("radioButtonTrue").hasAttribute("checked")) {
                form[i].defaultChecked = true;
                checked = true;
                break;
            } else {
                form[i].defaultChecked = false;
                checked = false;
                break;
            }
        }
    }

    form.reset();

    $('input[type="file"]').each(function(){
            setDefaultText(this);
    });
}

function setDefaultText(e) {
    var id = e.id+"Label";
    var label = document.getElementById(id);
    label.innerHTML = label.getAttribute("default-text");
}

function sendForm(form, e) {
    var formData = new FormData(form);
    $.ajax({
        url: form.action + form.getAttribute("badge-id"),
        type: 'PUT',
        data: formData,
        success: function (result) {
            sessionStorage.setItem("badgeUpdated", "true");
            sessionStorage.setItem("badgeUpdatedName", result.name);
            location.href = URL_add_parameter(location.href, 'badgeID', result.id);
        },
        error: function (result) {
            AJS.messages.error({
                body: JSON.parse(result.responseText).message
            });
        },
        cache: false,
        contentType: false,
        processData: false
    });
}

function sendFormNewBadge(form, e) {
    var formData = new FormData(form);
    $.ajax({
        url: form.action,
        type: 'PUT',
        data: formData,
        success: function (result) {
            sessionStorage.setItem("newBadgeCreated", "true");
            sessionStorage.setItem("newBadgeName", result.name);
            location.href = URL_add_parameter(location.href, 'badgeID', result.id);
        },
        error: function (result) {
            AJS.messages.error({
                body: JSON.parse(result.responseText).message
            });
        },
        cache: false,
        contentType: false,
        processData: false
    });
}

window.onload = function() {
    var badgeUpdated = sessionStorage.getItem("badgeUpdated");
    var newBadgeCreated = sessionStorage.getItem("newBadgeCreated");
    var badgeDeleted = sessionStorage.getItem("badgeDeleted");
    var badgeUpdatedName = sessionStorage.getItem("badgeUpdatedName");
    var newBadgeName = sessionStorage.getItem("newBadgeName");
    var badgeDeletedName = sessionStorage.getItem("badgeDeletedName");

    if (badgeUpdated) {
        sessionStorage.removeItem("badgeUpdated");
        sessionStorage.removeItem("badgeUpdatedName");
        AJS.messages.success({
            body: "\"" + badgeUpdatedName + "\"" + " " +document.getElementById("i18n").getAttribute("i18n-badges-successfully-updated")
        });
    }

    if (newBadgeCreated) {
        sessionStorage.removeItem("newBadgeCreated");
        sessionStorage.removeItem("newBadgeName");
        AJS.messages.success({
            body: "\"" + newBadgeName + "\"" + " " + document.getElementById("i18n").getAttribute("i18n-badges-successfully-created")
        });
    }

    if (badgeDeleted) {
        sessionStorage.removeItem("badgeDeleted");
        sessionStorage.removeItem("badgeDeletedName");
        AJS.messages.success({
            body: "\"" + badgeDeletedName + "\"" + " " + document.getElementById("i18n").getAttribute("i18n-badges-successfully-deleted")
        });
    }
}

function URL_add_parameter(url, param, value){
    var hash       = {};
    var parser     = document.createElement('a');

    parser.href    = url;

    var parameters = parser.search.split(/\?|&/);

    for(var i=0; i < parameters.length; i++) {
        if(!parameters[i])
            continue;

        var ary      = parameters[i].split('=');
        hash[ary[0]] = ary[1];
    }

    hash[param] = value;

    var list = [];
    Object.keys(hash).forEach(function (key) {
        list.push(key + '=' + hash[key]);
    });

    parser.search = '?' + list.join('&');
    return parser.href;
}

function openGiveBadges() {
    location.href = document.getElementById("context-path").value
    + "/admin/plugins/badge/giveBadges.action?badgeId="
    + document.getElementById("BadgeForm").getAttribute("badge-id");
}
