/*
 * Decompiled with CFR 0.152.
 */
package com.agileants.confluence.plugin.badge.utils;

import com.agileants.confluence.plugin.badge.utils.Convert;
import java.util.ResourceBundle;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class UtilsMode {
    private static final Logger logger = LoggerFactory.getLogger(UtilsMode.class);
    private static final String PROPERTY_DEVELOPER_MODE_VALUE = "development";
    private static final boolean isDeveloper = UtilsMode.getDeveloperMode();

    private UtilsMode() {
        throw new IllegalStateException("utility class.");
    }

    private static boolean getDeveloperMode() {
        boolean result = UtilsMode.isDeveloperPropertiesFile();
        if (logger.isInfoEnabled()) {
            logger.info(String.format("developer mode: %s.", result));
        }
        return result;
    }

    public static boolean isDeveloper() {
        return isDeveloper;
    }

    private static boolean isDeveloperPropertiesFile() {
        boolean result;
        ResourceBundle rb = ResourceBundle.getBundle("badgeplugin");
        String value = rb.getString("mode");
        boolean bl = result = Convert.isEmpty(value) ? false : PROPERTY_DEVELOPER_MODE_VALUE.equals(value);
        if (logger.isInfoEnabled()) {
            logger.info(String.format("developer mode property file: %s.", result));
        }
        return result;
    }
}

