/*
 * Decompiled with CFR 0.152.
 */
package com.agileants.confluence.plugin.badge.utils;

import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class DateUtils {
    private static final Logger logger = LoggerFactory.getLogger(DateUtils.class);
    private static final long DAY_IN_MILLIS = 86400000L;
    private static final String ISO8601_PATTERN = "yyyy-MM-dd";

    private DateUtils() {
        throw new IllegalStateException("utility class.");
    }

    public static String todayISO8601() {
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat(ISO8601_PATTERN);
        String result = simpleDateFormat.format(new Date());
        return result;
    }

    public static long todayInMillis() {
        String today = DateUtils.todayISO8601();
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat(ISO8601_PATTERN);
        long result = 0L;
        try {
            result = simpleDateFormat.parse(today).getTime();
        }
        catch (ParseException e) {
            logger.error(String.format("Could not parse ''.", today), (Throwable)e);
        }
        return result;
    }

    public static String daysBackISO8601(int days) {
        long daysBackInMillis = DateUtils.daysBackInMillis(days);
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat(ISO8601_PATTERN);
        String result = simpleDateFormat.format(new Date(daysBackInMillis));
        return result;
    }

    public static long daysBackInMillis(int days) {
        long todayInMillis = DateUtils.todayInMillis();
        long result = todayInMillis - (long)days * 86400000L;
        return result;
    }
}

