/*
 * Decompiled with CFR 0.152.
 */
package com.agileants.confluence.plugin.badge.utils;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class Convert {
    private static final Logger logger = LoggerFactory.getLogger(Convert.class);
    public static final String EMPTY_STRING = "";
    public static final String UNKNOWN = "UNKNOWN";

    private Convert() {
        throw new IllegalStateException("utility class.");
    }

    public static boolean isEmpty(String text) {
        return text == null || EMPTY_STRING.equals(text.trim());
    }

    public static int getInt(String text, int defaultValue) {
        int result = defaultValue;
        try {
            result = Integer.parseInt(text);
        }
        catch (NumberFormatException ex) {
            logger.warn(String.format("can't convert '%s' to int.", text), (Throwable)ex);
        }
        return result;
    }

    public static Integer getInt(String text, Integer defaultValue) {
        Integer result = defaultValue;
        try {
            result = Integer.valueOf(text);
        }
        catch (NumberFormatException ex) {
            logger.warn(String.format("can't convert '%s' to Integer.", text), (Throwable)ex);
        }
        return result;
    }

    public static String getClassName(Class<?> clazz) {
        return clazz == null ? UNKNOWN : clazz.getSimpleName();
    }

    public static String getClassName(Object object) {
        return object == null ? UNKNOWN : Convert.getClassName(object.getClass());
    }

    public static String getClassFullName(Class<?> clazz) {
        return clazz == null ? UNKNOWN : clazz.getCanonicalName();
    }

    public static String getClassFullName(Object object) {
        return object == null ? UNKNOWN : Convert.getClassFullName(object.getClass());
    }
}

