/*
 * Decompiled with CFR 0.152.
 */
package com.agileants.confluence.plugin.badge.utils;

import com.agileants.confluence.plugin.badge.activeobjects.BadgeAO;
import com.agileants.confluence.plugin.badge.enums.Level;
import com.agileants.confluence.plugin.badge.objects.json.Badge;

public final class BadgeUtils {
    private BadgeUtils() throws IllegalAccessException {
        throw new IllegalAccessException("utility class.");
    }

    public static Level calculateLevel(BadgeAO badgeAO, int count) {
        if (count < badgeAO.getThresholdBronze()) {
            return Level.NONE;
        }
        if (badgeAO.getThresholdBronze() <= count && count < badgeAO.getThresholdSilver()) {
            return Level.BRONZE;
        }
        if (badgeAO.getThresholdSilver() <= count && count < badgeAO.getThresholdGold()) {
            return Level.SILVER;
        }
        return Level.GOLD;
    }

    public static Level calculateLevel(Badge badge, int count) {
        int bronze = badge.getThresholdBronze();
        if (count < bronze) {
            return Level.NONE;
        }
        int silver = badge.getThresholdSilver();
        if (bronze <= count && count < silver) {
            return Level.BRONZE;
        }
        int gold = badge.getThresholdGold();
        if (silver <= count && count < gold) {
            return Level.SILVER;
        }
        return Level.GOLD;
    }

    public static boolean checkLevelUp(BadgeAO badgeAO, int oldCount, int newCount) {
        int quotientNewCount;
        int quotientOldCount;
        Level newLevel;
        if (oldCount == newCount || oldCount < 0 || newCount < 1) {
            return false;
        }
        boolean result = false;
        Level oldLevel = BadgeUtils.calculateLevel(badgeAO, oldCount);
        if (oldLevel != (newLevel = BadgeUtils.calculateLevel(badgeAO, newCount))) {
            result = true;
        }
        if (oldLevel == Level.GOLD && newLevel == Level.GOLD && (quotientOldCount = oldCount / badgeAO.getThresholdGold()) < (quotientNewCount = newCount / badgeAO.getThresholdGold())) {
            return true;
        }
        return result;
    }

    public static String getKeyName(String badgeId) {
        return String.format("%s.%s", badgeId, "name");
    }

    public static String getKeyDesc(String badgeId) {
        return String.format("%s.%s", badgeId, "desc");
    }

    public static int calculatePoints(int bronze, int silver, int gold) {
        return 1 * bronze + 2 * silver + 3 * gold;
    }

    public static String badgeAOToString(BadgeAO badgeAO) {
        return String.format("[Id: '%s', ThresholdBronze: '%d', ThresholdSilver: '%d', ThresholdGold: '%d', BronzeImage: '%s', SilverImage : '%s', GoldImage: '%s', NeutralImage: '%s']", badgeAO.getID(), badgeAO.getThresholdBronze(), badgeAO.getThresholdSilver(), badgeAO.getThresholdGold(), badgeAO.getBronzeImage(), badgeAO.getSilverImage(), badgeAO.getGoldImage(), badgeAO.getNeutralImage());
    }

    public static String badgeAOToString(BadgeAO badgeAO, String name, String description) {
        return String.format("[Id: '%s', Name: '%s', Description: '%s', ThresholdBronze: '%d', ThresholdSilver: '%d', ThresholdGold: '%d', BronzeImage: '%s', SilverImage : '%s', GoldImage: '%s', NeutralImage: '%s']", badgeAO.getID(), name, description, badgeAO.getThresholdBronze(), badgeAO.getThresholdSilver(), badgeAO.getThresholdGold(), badgeAO.getBronzeImage(), badgeAO.getSilverImage(), badgeAO.getGoldImage(), badgeAO.getNeutralImage());
    }
}

