/*
 * Decompiled with CFR 0.152.
 */
package com.agileants.confluence.plugin.badge.upgradetasks;

import com.agileants.confluence.plugin.badge.activeobjects.BadgeAO;
import com.agileants.confluence.plugin.badge.activeobjects.I18nAO;
import com.agileants.confluence.plugin.badge.activeobjects.UserAO;
import com.agileants.confluence.plugin.badge.managers.ListenerManager;
import com.agileants.confluence.plugin.badge.objects.json.Badge;
import com.agileants.confluence.plugin.badge.utils.BadgeUtils;
import com.atlassian.activeobjects.external.ActiveObjects;
import com.atlassian.activeobjects.external.ActiveObjectsUpgradeTask;
import com.atlassian.activeobjects.external.ModelVersion;
import com.atlassian.core.util.ClassLoaderUtils;
import com.google.gson.Gson;
import com.google.gson.reflect.TypeToken;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.lang.reflect.Type;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import javax.inject.Inject;
import net.java.ao.DBParam;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class InitTask
implements ActiveObjectsUpgradeTask {
    private static final Logger logger = LoggerFactory.getLogger(InitTask.class);
    private final ListenerManager listenerManager;

    @Inject
    public InitTask(ListenerManager listenerManager) {
        this.listenerManager = listenerManager;
    }

    public ModelVersion getModelVersion() {
        return ModelVersion.valueOf((String)"61");
    }

    public void upgrade(ModelVersion currentVersion, ActiveObjects ao) {
        logger.info("InitTask started. Current version: '{}'. New Version: '{}'.", (Object)currentVersion, (Object)this.getModelVersion());
        try (InputStream is = ClassLoaderUtils.getResourceAsStream((String)"badgeSettings.json", this.getClass());
             InputStreamReader reader = new InputStreamReader(is, StandardCharsets.UTF_8);){
            Type thresholdsListType = new TypeToken<ArrayList<Badge>>(){}.getType();
            Gson gson = new Gson();
            List badges = (List)gson.fromJson((Reader)reader, thresholdsListType);
            if (logger.isDebugEnabled()) {
                logger.debug("Number of badges: {}", (Object)badges.size());
            }
            ao.migrate(new Class[]{BadgeAO.class});
            ao.migrate(new Class[]{I18nAO.class});
            ArrayList<BadgeAO> oldBadges = new ArrayList<BadgeAO>(Arrays.asList((BadgeAO[])ao.find(BadgeAO.class)));
            for (BadgeAO badgeAO : oldBadges) {
                Badge newBadge = badges.stream().filter(badge -> badgeAO.getID().equals(badge.getId())).findAny().orElse(null);
                if (newBadge != null) continue;
                ao.deleteWithSQL(BadgeAO.class, "ID = ?", new Object[]{badgeAO.getID()});
                ao.deleteWithSQL(I18nAO.class, "KEY = ?", new Object[]{BadgeUtils.getKeyName(badgeAO.getID())});
                ao.deleteWithSQL(I18nAO.class, "KEY = ?", new Object[]{BadgeUtils.getKeyDesc(badgeAO.getID())});
                ao.deleteWithSQL(UserAO.class, "BADGE_ID = ?", new Object[]{badgeAO.getID()});
                if (!logger.isDebugEnabled()) continue;
                logger.debug("Badge and user data for Badge '{}' deleted.", (Object)badgeAO.getID());
            }
            for (Badge badge2 : badges) {
                BadgeAO oldBadge = (BadgeAO)ao.get(BadgeAO.class, (Object)badge2.getId());
                if (oldBadge != null && (oldBadge.getThresholdBronze() != badge2.getThresholdBronze().intValue() || oldBadge.getThresholdSilver() != badge2.getThresholdSilver().intValue() || oldBadge.getThresholdGold() != badge2.getThresholdGold().intValue())) {
                    ArrayList<UserAO> userAOs = new ArrayList<UserAO>(Arrays.asList((UserAO[])ao.find(UserAO.class, "BADGE_ID = ?", new Object[]{badge2.getId()})));
                    for (UserAO userAO : userAOs) {
                        userAO.setLevel(BadgeUtils.calculateLevel(badge2, userAO.getCount()));
                        userAO.save();
                    }
                    if (logger.isDebugEnabled()) {
                        logger.debug("Thresholds for Badge '{}' changed. OldThresholdBronze:'{}', OldThresholdSilver: '{}', OldThresholdGold: '{}', NewThresholdBronze: '{}', NewThresholdSilver: '{}', NewThresholdGold: '{}'.", new Object[]{badge2.getId(), oldBadge.getThresholdBronze(), oldBadge.getThresholdSilver(), oldBadge.getThresholdGold(), badge2.getThresholdBronze(), badge2.getThresholdSilver(), badge2.getThresholdGold()});
                    }
                }
                ao.deleteWithSQL(BadgeAO.class, "ID = ?", new Object[]{badge2.getId()});
                ao.create(BadgeAO.class, new DBParam[]{new DBParam("ID", (Object)badge2.getId()), new DBParam("ENABLED", (Object)badge2.getEnabled()), new DBParam("THRESHOLD_BRONZE", (Object)badge2.getThresholdBronze()), new DBParam("THRESHOLD_SILVER", (Object)badge2.getThresholdSilver()), new DBParam("THRESHOLD_GOLD", (Object)badge2.getThresholdGold()), new DBParam("BRONZE_IMAGE", (Object)badge2.getBronzeImage()), new DBParam("SILVER_IMAGE", (Object)badge2.getSilverImage()), new DBParam("GOLD_IMAGE", (Object)badge2.getGoldImage()), new DBParam("NEUTRAL_IMAGE", (Object)badge2.getNeutralImage())});
                if (logger.isDebugEnabled()) {
                    logger.debug("Badge created: '{}'.", (Object)badge2.toString());
                }
                String keyName = BadgeUtils.getKeyName(badge2.getId());
                String keyDesc = BadgeUtils.getKeyDesc(badge2.getId());
                ao.deleteWithSQL(I18nAO.class, "KEY = ?", new Object[]{keyName});
                ao.deleteWithSQL(I18nAO.class, "KEY = ?", new Object[]{keyDesc});
                for (int i = 0; i < badge2.getNames().length; ++i) {
                    ao.create(I18nAO.class, new DBParam[]{new DBParam("KEY", (Object)keyName), new DBParam("LOCALE", (Object)badge2.getNames()[i].getLocale()), new DBParam("VALUE", (Object)badge2.getNames()[i].getValue())});
                    logger.debug("I18N entries for Badge '{}' created. KEY: '{}', LOCALE: '{}', VALUE: '{}'.", new Object[]{badge2.getId(), keyName, badge2.getNames()[i].getLocale(), badge2.getNames()[i].getValue()});
                    ao.create(I18nAO.class, new DBParam[]{new DBParam("KEY", (Object)keyDesc), new DBParam("LOCALE", (Object)badge2.getDescriptions()[i].getLocale()), new DBParam("VALUE", (Object)badge2.getDescriptions()[i].getValue())});
                    logger.debug("I18N entries for Badge '{}' created. KEY: '{}', LOCALE: '{}', VALUE: '{}'.", new Object[]{badge2.getId(), keyDesc, badge2.getDescriptions()[i].getLocale(), badge2.getDescriptions()[i].getValue()});
                }
                if (badge2.getEnabled().booleanValue()) {
                    this.listenerManager.enableListener(badge2.getId());
                    continue;
                }
                this.listenerManager.disableListener(badge2.getId());
            }
        }
        catch (IOException e) {
            logger.error("Could not load badgeSettings.json. Exception: {}", (Throwable)e);
        }
    }
}

