/*
 * Decompiled with CFR 0.152.
 */
package com.agileants.confluence.plugin.badge.services.impl;

import com.agileants.confluence.plugin.badge.activeobjects.UserAO;
import com.agileants.confluence.plugin.badge.services.UserService;
import com.agileants.confluence.plugin.badge.services.impl.ConfluenceUserSourceDefault;
import com.agileants.confluence.plugin.badge.services.impl.DevelopConfluenceUserImpl;
import com.agileants.confluence.plugin.badge.utils.MathUtils;
import com.atlassian.confluence.setup.settings.SettingsManager;
import com.atlassian.confluence.user.ConfluenceUser;
import com.atlassian.confluence.user.UserAccessor;
import com.atlassian.confluence.user.actions.ProfilePictureInfo;
import com.atlassian.user.User;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ConfluenceUserSourceDeveloper
extends ConfluenceUserSourceDefault {
    private static final Logger logger = LoggerFactory.getLogger(ConfluenceUserSourceDeveloper.class);
    private final UserService userService;

    ConfluenceUserSourceDeveloper(UserAccessor userAccessor, SettingsManager settingsManager, UserService userService) {
        super(userAccessor, settingsManager);
        if (userAccessor == null) {
            throw new IllegalArgumentException("userAccessor can't be null.");
        }
        if (settingsManager == null) {
            throw new IllegalArgumentException("settingsManager can't be null.");
        }
        this.userService = userService;
        if (logger.isDebugEnabled()) {
            logger.debug("created.");
        }
    }

    @Override
    public Map<String, ConfluenceUser> getAll() {
        if (logger.isDebugEnabled()) {
            logger.debug("getAll(): start..");
        }
        Map<String, ConfluenceUser> result = super.getAll();
        for (UserAO userAO : this.userService.all(Integer.MAX_VALUE)) {
            String userKey = userAO.getUserKey();
            if (result.containsKey(userKey)) continue;
            if (logger.isDebugEnabled()) {
                logger.debug(String.format("user '%s' not confluence user or disabled confluence user -> add to list.", userKey));
            }
            DevelopConfluenceUserImpl user = new DevelopConfluenceUserImpl(userKey);
            result.put(userKey, (ConfluenceUser)user);
        }
        if (logger.isDebugEnabled()) {
            logger.debug("getAll(): DONE.");
        }
        return result;
    }

    @Override
    public String getProfilePictureInfo(ConfluenceUser confluenceUser) {
        String result;
        String profilePicturePath = String.format("%s/rest/badge/1.0/test/data/user/profilePicture/%d", this.getContextPath(), MathUtils.getRandomNumber(1, 1000001));
        try {
            ProfilePictureInfo profilePictureInfo = this.getUserAccessor().getUserProfilePicture((User)confluenceUser);
            result = profilePictureInfo == null || profilePictureInfo.isDefault() ? profilePicturePath : profilePictureInfo.getUriReference();
        }
        catch (Throwable th) {
            result = profilePicturePath;
        }
        if (logger.isDebugEnabled()) {
            logger.debug(String.format("user '%s', profilePicturePath: '%s'", confluenceUser.getKey(), result));
        }
        return result;
    }

    @Override
    public ConfluenceUser getUserByName(String username) {
        Object result = super.getUserByName(username);
        if (result == null) {
            result = new DevelopConfluenceUserImpl(username);
        }
        return result;
    }

    @Override
    public ConfluenceUser getUserByKey(String userKey) {
        Object result = super.getUserByKey(userKey);
        if (result == null) {
            result = new DevelopConfluenceUserImpl(userKey);
        }
        return result;
    }
}

