/*
 * Decompiled with CFR 0.152.
 */
package com.agileants.confluence.plugin.badge.services.impl;

import com.agileants.confluence.plugin.badge.services.IConfluenceUserSource;
import com.atlassian.confluence.setup.settings.SettingsManager;
import com.atlassian.confluence.user.ConfluenceUser;
import com.atlassian.confluence.user.UserAccessor;
import com.atlassian.confluence.user.actions.ProfilePictureInfo;
import com.atlassian.sal.api.user.UserKey;
import com.atlassian.user.User;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ConfluenceUserSourceDefault
implements IConfluenceUserSource {
    private static final Logger logger = LoggerFactory.getLogger(ConfluenceUserSourceDefault.class);
    private final UserAccessor userAccessor;
    private final SettingsManager settingsManager;

    ConfluenceUserSourceDefault(UserAccessor userAccessor, SettingsManager settingsManager) {
        if (userAccessor == null) {
            throw new IllegalArgumentException("userAccessor can't be null.");
        }
        if (settingsManager == null) {
            throw new IllegalArgumentException("settingsManager can't be null.");
        }
        this.userAccessor = userAccessor;
        this.settingsManager = settingsManager;
        if (logger.isDebugEnabled()) {
            logger.debug("created.");
        }
    }

    @Override
    public Map<String, ConfluenceUser> getAll() {
        if (logger.isDebugEnabled()) {
            logger.debug("getAll(): start..");
        }
        HashMap<String, ConfluenceUser> result = new HashMap<String, ConfluenceUser>();
        List usernames = this.userAccessor.getUserNamesWithConfluenceAccess();
        for (String username : usernames) {
            ConfluenceUser user = this.userAccessor.getUserByName(username);
            if (this.userAccessor.isDeactivated(user.getName())) continue;
            result.put(user.getKey().getStringValue(), user);
        }
        if (logger.isDebugEnabled()) {
            logger.debug("getAll(): DONE.");
        }
        return result;
    }

    @Override
    public String getProfilePictureInfo(ConfluenceUser confluenceUser) {
        String result;
        try {
            ProfilePictureInfo profilePictureInfo = this.userAccessor.getUserProfilePicture((User)confluenceUser);
            result = profilePictureInfo == null ? "/images/icons/profilepics/anonymous.svg" : profilePictureInfo.getUriReference();
        }
        catch (Throwable th) {
            result = "/images/icons/profilepics/anonymous.svg";
        }
        return result;
    }

    @Override
    public ConfluenceUser getUserByName(String username) {
        return this.userAccessor.getUserByName(username);
    }

    @Override
    public ConfluenceUser getUserByKey(String userKey) {
        return this.userAccessor.getUserByKey(new UserKey(userKey));
    }

    protected final UserAccessor getUserAccessor() {
        return this.userAccessor;
    }

    protected final String getContextPath() {
        String contextPath = this.settingsManager.getGlobalSettings().getBaseUrl();
        if (logger.isDebugEnabled()) {
            logger.debug("ContextPath: '{}'.", (Object)contextPath);
        }
        return contextPath;
    }
}

