/*
 * Decompiled with CFR 0.152.
 */
package com.agileants.confluence.plugin.badge.services;

import com.agileants.confluence.plugin.badge.activeobjects.BadgeAO;
import com.agileants.confluence.plugin.badge.activeobjects.UserAO;
import com.agileants.confluence.plugin.badge.enums.Level;
import com.agileants.confluence.plugin.badge.services.BadgeService;
import com.agileants.confluence.plugin.badge.services.IConfluenceUserSource;
import com.agileants.confluence.plugin.badge.services.UserService;
import com.agileants.confluence.plugin.badge.services.impl.ConfluenceUserSource;
import com.agileants.confluence.plugin.badge.utils.BadgeUtils;
import com.atlassian.activeobjects.external.ActiveObjects;
import com.atlassian.confluence.setup.settings.SettingsManager;
import com.atlassian.confluence.user.UserAccessor;
import com.atlassian.plugin.spring.scanner.annotation.component.Scanned;
import com.atlassian.plugin.spring.scanner.annotation.imports.ComponentImport;
import com.atlassian.plugin.spring.scanner.annotation.imports.ConfluenceImport;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import javax.inject.Inject;
import javax.inject.Named;
import net.java.ao.DBParam;
import net.java.ao.Query;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;

@Scanned
@Named
public class UserServiceImpl
implements UserService {
    private static final Logger logger = LoggerFactory.getLogger(UserServiceImpl.class);
    private BadgeService badgeService;
    @ConfluenceImport
    private final UserAccessor userAccessor;
    @ComponentImport
    private final ActiveObjects ao;
    @ConfluenceImport
    private final SettingsManager settingsManager;
    private final IConfluenceUserSource confluenceUserSource;

    @Inject
    public UserServiceImpl(UserAccessor userAccessor, ActiveObjects ao, SettingsManager settingsManager) {
        this.userAccessor = userAccessor;
        this.ao = ao;
        this.settingsManager = settingsManager;
        this.confluenceUserSource = ConfluenceUserSource.get(this.userAccessor, this.settingsManager, this);
    }

    @Autowired
    public void setBadgeService(BadgeService badgeService) {
        this.badgeService = badgeService;
    }

    @Override
    public void recalculateLevels(String badgeID, BadgeAO badgeAO) {
        for (UserAO userAO : this.allByBadge(badgeID)) {
            userAO.setLevel(BadgeUtils.calculateLevel(badgeAO, userAO.getCount()));
            userAO.save();
        }
    }

    @Override
    public void increment(String userKey, String badgeID) {
        UserAO userAO = this.find(userKey, badgeID);
        if (userAO != null) {
            userAO.setCount(1 + userAO.getCount());
            userAO.save();
        } else {
            this.add(userKey, badgeID, 1, Level.NONE);
        }
    }

    @Override
    public Level levelUp(String userKey, String badgeID) {
        UserAO userAO = this.find(userKey, badgeID);
        if (userAO == null) {
            return null;
        }
        switch (userAO.getLevel()) {
            case NONE: {
                userAO.setLevel(Level.BRONZE);
                break;
            }
            case BRONZE: {
                userAO.setLevel(Level.SILVER);
                break;
            }
            case SILVER: {
                userAO.setLevel(Level.GOLD);
                break;
            }
        }
        userAO.setTime(System.currentTimeMillis());
        userAO.save();
        return userAO.getLevel();
    }

    @Override
    public UserAO add(String userKey, String badgeID, int count, Level level) {
        return this.add(userKey, badgeID, count, level, System.currentTimeMillis());
    }

    @Override
    public UserAO add(String userKey, String badgeID, int count, Level level, long time) {
        if (logger.isDebugEnabled()) {
            logger.debug(String.format("add user badge: userKey: '%s', badgeID: '%s', count: %d, level: %s, time: %d.", new Object[]{userKey, badgeID, count, level, time}));
        }
        if (this.find(userKey, badgeID) != null) {
            return this.update(userKey, badgeID, count, level, time);
        }
        return (UserAO)this.ao.create(UserAO.class, new DBParam[]{new DBParam("USER_KEY", (Object)userKey), new DBParam("BADGE_ID", (Object)badgeID), new DBParam("COUNT", (Object)count), new DBParam("LEVEL", (Object)level), new DBParam("TIME", (Object)time)});
    }

    @Override
    public UserAO update(String userKey, String badgeID, int count, Level level) {
        return this.update(userKey, badgeID, count, level, System.currentTimeMillis());
    }

    @Override
    public UserAO update(String userKey, String badgeID, int count, Level level, long time) {
        UserAO userAO;
        if (logger.isDebugEnabled()) {
            logger.debug(String.format("update user badge: userKey: '%s', badgeID: '%s', count: %d, level: %s, time: %d.", new Object[]{userKey, badgeID, count, level, time}));
        }
        if ((userAO = this.find(userKey, badgeID)) == null) {
            if (logger.isDebugEnabled()) {
                logger.debug(String.format("can't find user by userKey: '%s', stop update.", userKey));
            }
            return null;
        }
        if (count == 0) {
            this.deleteUserBadge(userKey, badgeID);
            return userAO;
        }
        userAO.setCount(count);
        userAO.setLevel(level);
        userAO.setTime(time);
        userAO.save();
        return userAO;
    }

    @Override
    public UserAO find(String userKey, String badgeID) {
        Query query = Query.select().where("USER_KEY = ? AND BADGE_ID = ?", new Object[]{userKey, badgeID}).limit(1);
        UserAO[] userAOs = (UserAO[])this.ao.find(UserAO.class, query);
        return userAOs.length > 0 ? userAOs[0] : null;
    }

    @Override
    public int getCount(String userKey, String badgeID) {
        UserAO userAO = this.find(userKey, badgeID);
        return userAO != null ? userAO.getCount() : 0;
    }

    @Override
    public void deleteAll() {
        this.ao.deleteWithSQL(UserAO.class, "COUNT >= 0", new Object[0]);
    }

    @Override
    public void deleteBadge(String badgeID) {
        this.ao.deleteWithSQL(UserAO.class, "BADGE_ID = ?", new Object[]{badgeID});
    }

    @Override
    public void deleteUser(String userKey) {
        this.ao.deleteWithSQL(UserAO.class, "USER_KEY = ?", new Object[]{userKey});
    }

    @Override
    public void deleteUserBadge(String userKey, String badgeID) {
        this.ao.deleteWithSQL(UserAO.class, "USER_KEY = ? AND BADGE_ID = ?", new Object[]{userKey, badgeID});
    }

    @Override
    public List<UserAO> all() {
        int limit = this.confluenceUserSource.getAll().size() * this.badgeService.all().size() + 100000;
        Query query = Query.select().limit(limit);
        return new ArrayList<UserAO>(Arrays.asList((UserAO[])this.ao.find(UserAO.class, query)));
    }

    @Override
    public List<UserAO> all(int limit) {
        Query query = Query.select().limit(limit);
        return new ArrayList<UserAO>(Arrays.asList((UserAO[])this.ao.find(UserAO.class, query)));
    }

    @Override
    public List<UserAO> allByUser(String userKey) {
        int limit = this.badgeService.all().size();
        Query query = Query.select().where("USER_KEY = ?", new Object[]{userKey}).limit(limit);
        UserAO[] userAOs = (UserAO[])this.ao.find(UserAO.class, query);
        ArrayList<UserAO> result = new ArrayList<UserAO>(Arrays.asList(userAOs));
        Collections.sort(result, Comparator.comparing(UserAO::getLevel));
        Collections.reverse(result);
        return result;
    }

    @Override
    public List<UserAO> allByBadge(String badgeID) {
        int limit = this.confluenceUserSource.getAll().size();
        Query query = Query.select().where("BADGE_ID = ?", new Object[]{badgeID}).limit(limit);
        UserAO[] userAOs = (UserAO[])this.ao.find(UserAO.class, query);
        ArrayList<UserAO> result = new ArrayList<UserAO>(Arrays.asList(userAOs));
        Collections.sort(result, Comparator.comparing(UserAO::getCount));
        return result;
    }

    @Override
    public List<UserAO> recentByUser(String userKey, int limit) {
        List<UserAO> result = this.allByUser(userKey);
        Collections.sort(result, Comparator.comparing(UserAO::getTime));
        Collections.reverse(result);
        if (result.size() <= limit) {
            return result;
        }
        return result.subList(0, limit);
    }
}

