/*
 * Decompiled with CFR 0.152.
 */
package com.agileants.confluence.plugin.badge.services;

import com.agileants.confluence.plugin.badge.activeobjects.BadgeAO;
import com.agileants.confluence.plugin.badge.activeobjects.RankingAO;
import com.agileants.confluence.plugin.badge.activeobjects.UserAO;
import com.agileants.confluence.plugin.badge.objects.dto.RankingRow;
import com.agileants.confluence.plugin.badge.services.IConfluenceUserSource;
import com.agileants.confluence.plugin.badge.services.RankingService;
import com.agileants.confluence.plugin.badge.services.UserService;
import com.agileants.confluence.plugin.badge.services.impl.ConfluenceUserSource;
import com.agileants.confluence.plugin.badge.utils.BadgeUtils;
import com.atlassian.activeobjects.external.ActiveObjects;
import com.atlassian.confluence.setup.settings.SettingsManager;
import com.atlassian.confluence.user.ConfluenceUser;
import com.atlassian.confluence.user.UserAccessor;
import com.atlassian.plugin.spring.scanner.annotation.imports.ConfluenceImport;
import com.atlassian.user.User;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.inject.Inject;
import javax.inject.Named;
import net.java.ao.DBParam;
import net.java.ao.Query;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Named
public class RankingServiceImpl
implements RankingService {
    private static final Logger logger = LoggerFactory.getLogger(RankingServiceImpl.class);
    private final IConfluenceUserSource confluenceUserSource;
    private final UserService userService;
    @ConfluenceImport
    private final UserAccessor userAccessor;
    @ConfluenceImport
    private final ActiveObjects ao;
    @ConfluenceImport
    private final SettingsManager settingsManager;

    @Inject
    public RankingServiceImpl(UserService userService, UserAccessor userAccessor, ActiveObjects ao, SettingsManager settingsManager) {
        if (userService == null) {
            throw new IllegalArgumentException("userService can't be null.");
        }
        if (userAccessor == null) {
            throw new IllegalArgumentException("userAccessor can't be null.");
        }
        if (ao == null) {
            throw new IllegalArgumentException("ao can't be null.");
        }
        if (settingsManager == null) {
            throw new IllegalArgumentException("settingsManager can't be null.");
        }
        this.userService = userService;
        this.userAccessor = userAccessor;
        this.ao = ao;
        this.settingsManager = settingsManager;
        this.confluenceUserSource = ConfluenceUserSource.get(this.userAccessor, this.settingsManager, this.userService);
    }

    private static void calculatePoints(BadgeAO badgeAO, UserAO userAO, RankingRow row) {
        switch (userAO.getLevel()) {
            case BRONZE: {
                row.incrementBronzeBadges();
                break;
            }
            case SILVER: {
                row.incrementSilverBadges();
                break;
            }
            case GOLD: {
                row.setGoldBadges(row.getGoldBadges() + userAO.getCount() / badgeAO.getThresholdGold());
                break;
            }
            default: {
                logger.error(String.format("unknown level: '%s'.", new Object[]{userAO.getLevel()}));
            }
        }
        row.setPoints(BadgeUtils.calculatePoints(row.getBronzeBadges(), row.getSilverBadges(), row.getGoldBadges()));
    }

    private static void calculateRank(List<RankingRow> rows, Map<String, ConfluenceUser> allUsers) {
        if (logger.isDebugEnabled()) {
            logger.debug("calculateRank(): start..");
        }
        int rank = 1;
        int prePoints = -1;
        for (RankingRow row : rows) {
            if (prePoints == row.getPoints()) {
                row.setRank(rank);
                prePoints = row.getPoints();
            } else if (prePoints == -1) {
                row.setRank(rank);
                prePoints = row.getPoints();
            } else {
                row.setRank(++rank);
                prePoints = row.getPoints();
            }
            row.calculateTotal();
            allUsers.remove(row.getKey());
        }
        if (logger.isDebugEnabled()) {
            logger.debug("calculateRank(): DONE.");
        }
    }

    private RankingAO add(int page, String userKey, String userName, String userFullName, String userProfilePicture, int rank, int bronzeBadges, int silverBadges, int goldBadges, int total, int points) {
        return (RankingAO)this.ao.create(RankingAO.class, new DBParam[]{new DBParam("PAGE", (Object)page), new DBParam("USER_KEY", (Object)userKey), new DBParam("USER_NAME", (Object)userName), new DBParam("USER_FULL_NAME", (Object)userFullName), new DBParam("USER_PROFILE_PICTURE", (Object)userProfilePicture), new DBParam("RANK", (Object)rank), new DBParam("BRONZE_BADGES", (Object)bronzeBadges), new DBParam("SILVER_BADGES", (Object)silverBadges), new DBParam("GOLD_BADGES", (Object)goldBadges), new DBParam("TOTAL", (Object)total), new DBParam("POINTS", (Object)points)});
    }

    private RankingAO add(RankingRow rankingRow) {
        return this.add(rankingRow.getPage(), rankingRow.getKey(), rankingRow.getUsername(), rankingRow.getUserFullName(), rankingRow.getUserProfilePicture(), rankingRow.getRank(), rankingRow.getBronzeBadges(), rankingRow.getSilverBadges(), rankingRow.getGoldBadges(), rankingRow.getTotal(), rankingRow.getPoints());
    }

    private void deleteRanking() {
        if (logger.isDebugEnabled()) {
            logger.debug("delete ranking: start..");
        }
        this.ao.deleteWithSQL(RankingAO.class, "PAGE > -1 ", new Object[0]);
        if (logger.isDebugEnabled()) {
            logger.debug("delete ranking: DONE.");
        }
    }

    @Override
    public void saveRanking(List<RankingRow> rows) {
        if (logger.isDebugEnabled()) {
            logger.debug("save ranking: start..");
        }
        this.deleteRanking();
        for (RankingRow row : rows) {
            this.add(row);
        }
        if (logger.isDebugEnabled()) {
            logger.debug(String.format("save ranking: DONE. wrote %d entries.", rows.size()));
        }
    }

    @Override
    public List<RankingAO> getRanking() {
        int limit = this.confluenceUserSource.getAll().size() + 10000;
        Query query = Query.select().limit(limit);
        ArrayList<RankingAO> result = new ArrayList<RankingAO>(Arrays.asList((RankingAO[])this.ao.find(RankingAO.class, query)));
        result.sort(Comparator.comparing(RankingAO::getRank));
        return result;
    }

    @Override
    public List<RankingAO> getRankingByPage(int page) {
        int limit = 20;
        Query query = Query.select().where("PAGE = ?", new Object[]{page}).limit(20);
        RankingAO[] rankingAOS = (RankingAO[])this.ao.find(RankingAO.class, query);
        ArrayList<RankingAO> result = new ArrayList<RankingAO>(Arrays.asList(rankingAOS));
        result.sort(Comparator.comparing(RankingAO::getRank));
        return result;
    }

    @Override
    public List<RankingAO> getRankingByUserKey(String userKey) {
        Query query = Query.select().where("USER_KEY = ?", new Object[]{userKey}).limit(1);
        RankingAO[] rankingAOS = (RankingAO[])this.ao.find(RankingAO.class, query);
        RankingAO rankingAO = rankingAOS.length > 0 ? rankingAOS[0] : null;
        return rankingAO == null ? new ArrayList() : this.getRankingByPage(rankingAO.getPage());
    }

    @Override
    public List<RankingAO> getRankingByUsername(String username) {
        ConfluenceUser user = this.confluenceUserSource.getUserByName(username);
        return user == null ? new ArrayList<RankingAO>() : this.getRankingByUserKey(user.getKey().getStringValue());
    }

    @Override
    public int getRank(String userKey) {
        Query query = Query.select().where("USER_KEY = ?", new Object[]{userKey}).limit(1);
        RankingAO[] rankingAOS = (RankingAO[])this.ao.find(RankingAO.class, query);
        return rankingAOS.length > 0 ? rankingAOS[0].getRank() : 0;
    }

    @Override
    public List<RankingRow> calculateRanking(Map<String, ConfluenceUser> allUsers, List<UserAO> userAOs, Map<String, BadgeAO> badgeAOs, int paging) {
        if (logger.isDebugEnabled()) {
            logger.debug("calculate ranking: start..");
        }
        List<RankingRow> rows = this.getRanking(allUsers, userAOs, badgeAOs);
        RankingServiceImpl.calculateRank(rows, allUsers);
        this.appendUsersWithoutBadges(allUsers, rows);
        RankingServiceImpl.applyPaging(rows, paging);
        if (logger.isDebugEnabled()) {
            logger.debug("calculate ranking: DONE.");
        }
        return rows;
    }

    private List<RankingRow> getRanking(Map<String, ConfluenceUser> users, List<UserAO> userAOs, Map<String, BadgeAO> badgeAOs) {
        if (logger.isDebugEnabled()) {
            logger.debug("getRanking(): start..");
        }
        Map<String, RankingRow> rows = this.createRanking(users, userAOs, badgeAOs);
        ArrayList<RankingRow> result = new ArrayList<RankingRow>(rows.values());
        Collections.sort(result, Comparator.comparing(RankingRow::getPoints, Comparator.reverseOrder()).thenComparing(Comparator.comparingInt(RankingRow::getGoldBadges).reversed()).thenComparing(Comparator.comparingInt(RankingRow::getSilverBadges).reversed()).thenComparing(Comparator.comparingInt(RankingRow::getBronzeBadges).reversed()));
        if (logger.isDebugEnabled()) {
            logger.debug("getRanking(): DONE.");
        }
        return result;
    }

    private void appendUsersWithoutBadges(Map<String, ConfluenceUser> users, List<RankingRow> ranking) {
        if (logger.isDebugEnabled()) {
            logger.debug("appendUsersWithoutBadges(): start..");
        }
        int lastRank = ranking.isEmpty() ? 1 : ranking.get(ranking.size() - 1).getRank() + 1;
        ArrayList<ConfluenceUser> usersList = new ArrayList<ConfluenceUser>(users.values());
        usersList.sort(Comparator.comparing(User::getFullName));
        Map<String, RankingRow> rankingMap = ranking.stream().collect(Collectors.toMap(RankingRow::getKey, rankingRow -> rankingRow));
        for (ConfluenceUser user : usersList) {
            if (rankingMap.containsKey(user.getKey().getStringValue())) continue;
            RankingRow row = this.createRankingRow(user);
            row.setRank(lastRank);
            ranking.add(row);
        }
        if (logger.isDebugEnabled()) {
            logger.debug("appendUsersWithoutBadges(): DONE.");
        }
    }

    private static void applyPaging(List<RankingRow> rows, int paging) {
        if (logger.isDebugEnabled()) {
            logger.debug("applyPaging(): start..");
        }
        if (paging < 1) {
            throw new IllegalArgumentException("paging must be greater or equal to 1.");
        }
        for (int i = 0; i < rows.size(); ++i) {
            rows.get(i).setPage(i / paging);
        }
        if (logger.isDebugEnabled()) {
            logger.debug("applyPaging(): DONE.");
        }
    }

    private Map<String, RankingRow> createRanking(Map<String, ConfluenceUser> users, List<UserAO> userAOs, Map<String, BadgeAO> badgeAOs) {
        if (logger.isDebugEnabled()) {
            logger.debug("createRanking(): start..");
        }
        HashMap<String, RankingRow> result = new HashMap<String, RankingRow>();
        for (UserAO userAO : userAOs) {
            String userKey = userAO.getUserKey();
            if (!users.containsKey(userKey)) {
                if (!logger.isDebugEnabled()) continue;
                logger.debug(String.format("User with key '%s' not in users map -> continue work.", userKey));
                continue;
            }
            BadgeAO badgeAO = badgeAOs.get(userAO.getBadgeID());
            if (!badgeAO.getEnabled()) {
                if (!logger.isDebugEnabled()) continue;
                logger.debug(String.format("Badge '%s' not enabled -> continue work.", badgeAO.getID()));
                continue;
            }
            RankingRow row = (RankingRow)result.get(userAO.getUserKey());
            if (row == null) {
                row = this.createRankingRow(users.get(userAO.getUserKey()));
                result.put(userAO.getUserKey(), row);
            }
            RankingServiceImpl.calculatePoints(badgeAO, userAO, row);
        }
        if (logger.isDebugEnabled()) {
            logger.debug("createRanking(): DONE.");
        }
        return result;
    }

    private RankingRow createRankingRow(ConfluenceUser confluenceUser) {
        return new RankingRow(confluenceUser.getKey().getStringValue(), confluenceUser.getName(), confluenceUser.getFullName(), this.confluenceUserSource.getProfilePictureInfo(confluenceUser));
    }
}

