/*
 * Decompiled with CFR 0.152.
 */
package com.agileants.confluence.plugin.badge.services;

import com.agileants.confluence.plugin.badge.activeobjects.BadgeAO;
import com.agileants.confluence.plugin.badge.enums.Level;
import com.agileants.confluence.plugin.badge.managers.LicenseManager;
import com.agileants.confluence.plugin.badge.services.BadgeService;
import com.agileants.confluence.plugin.badge.services.NotificationService;
import com.agileants.confluence.plugin.badge.utils.Convert;
import com.atlassian.confluence.languages.LocaleManager;
import com.atlassian.confluence.setup.settings.SettingsManager;
import com.atlassian.confluence.user.ConfluenceUser;
import com.atlassian.confluence.user.UserAccessor;
import com.atlassian.mywork.model.NotificationBuilder;
import com.atlassian.mywork.service.LocalNotificationService;
import com.atlassian.plugin.spring.scanner.annotation.imports.ComponentImport;
import com.atlassian.plugin.spring.scanner.annotation.imports.ConfluenceImport;
import com.atlassian.sal.api.message.I18nResolver;
import com.atlassian.sal.api.user.UserKey;
import com.atlassian.user.User;
import java.io.Serializable;
import java.util.Locale;
import java.util.concurrent.ExecutionException;
import javax.inject.Inject;
import javax.inject.Named;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Named
public class NotificationServiceImpl
implements NotificationService {
    private static final Logger logger = LoggerFactory.getLogger(NotificationServiceImpl.class);
    private final LocalNotificationService localNotificationService;
    private final UserAccessor userAccessor;
    private final BadgeService badgeService;
    private final I18nResolver i18n;
    private final LocaleManager localeManager;
    private final SettingsManager settingsManager;
    private final LicenseManager licenseManager;

    @Inject
    public NotificationServiceImpl(@ConfluenceImport LocalNotificationService localNotificationService, UserAccessor userAccessor, BadgeService badgeService, @ConfluenceImport I18nResolver i18n, @ConfluenceImport LocaleManager localeManager, @ComponentImport SettingsManager settingsManager, LicenseManager licenseManager) {
        if (localNotificationService == null) {
            throw new IllegalArgumentException("localNotificationService can't be null.");
        }
        if (userAccessor == null) {
            throw new IllegalArgumentException("userAccessor can't be null.");
        }
        if (badgeService == null) {
            throw new IllegalArgumentException("badgeService can't be null.");
        }
        if (i18n == null) {
            throw new IllegalArgumentException("i18n can't be null.");
        }
        if (localeManager == null) {
            throw new IllegalArgumentException("localeManager can't be null.");
        }
        if (settingsManager == null) {
            throw new IllegalArgumentException("settingsManager can't be null.");
        }
        if (licenseManager == null) {
            throw new IllegalArgumentException("licenseManager can't be null.");
        }
        this.localNotificationService = localNotificationService;
        this.userAccessor = userAccessor;
        this.badgeService = badgeService;
        this.i18n = i18n;
        this.localeManager = localeManager;
        this.settingsManager = settingsManager;
        this.licenseManager = licenseManager;
    }

    @Override
    public void levelUp(String userKey, String badgeId, Level level) {
        if (Convert.isEmpty(userKey)) {
            throw new IllegalArgumentException("userKey can't be null or empty string.");
        }
        if (Convert.isEmpty(badgeId)) {
            throw new IllegalArgumentException("badgeId can't be null or empty string.");
        }
        if (level == null) {
            throw new IllegalArgumentException("level can't be null.");
        }
        if (!this.licenseManager.checkLicense()) {
            return;
        }
        BadgeAO badge = this.badgeService.get(badgeId);
        if (badge == null) {
            logger.error(String.format("can't get badge for badgeId: '%s'.", badgeId));
            return;
        }
        if (!badge.getEnabled()) {
            logger.error(String.format("badge (badgeId: '%s') is disabled.", badgeId));
            return;
        }
        ConfluenceUser receiver = this.userAccessor.getUserByKey(new UserKey(userKey));
        if (receiver == null) {
            logger.error(String.format("can't get ConfluenceUser for userKey: '%s'.", userKey));
            return;
        }
        String username = receiver.getName();
        Locale locale = this.localeManager.getLocale((User)receiver);
        String iconUrl = "";
        String levelString = "";
        switch (level) {
            case BRONZE: {
                iconUrl = badge.getBronzeImage();
                levelString = this.i18n.getText(locale, "badges.level.bronze");
                break;
            }
            case SILVER: {
                iconUrl = badge.getSilverImage();
                levelString = this.i18n.getText(locale, "badges.level.silver");
                break;
            }
            case GOLD: {
                iconUrl = badge.getGoldImage();
                levelString = this.i18n.getText(locale, "badges.level.gold");
                break;
            }
            default: {
                logger.error(String.format("unknown level: %s", new Object[]{level}));
            }
        }
        if (logger.isDebugEnabled()) {
            logger.debug("Notification data: username='{}', locale='{}', iconUrl='{}', levelString='{}'.", new Object[]{username, locale, iconUrl, levelString});
        }
        try {
            this.localNotificationService.createOrUpdate(username, new NotificationBuilder().application("com.agileants.confluence.plugin.badge").itemTitle(this.i18n.getText(locale, "badges.new.badge.level.reached")).itemIconUrl(this.getContextPath() + "/download/resources/com.agileants.confluence.plugin.badge:badge-resources/images/badgeIcon.png").title(this.i18n.getText(locale, "badges.title")).iconUrl(iconUrl).description(this.i18n.getText(locale, "badges.you.reached.level.in", new Serializable[]{levelString, this.badgeService.getName(badgeId, locale)})).url(this.getContextPath() + "/users/viewmyprofile.action").createNotification()).get();
        }
        catch (InterruptedException | ExecutionException e) {
            logger.error(String.format("error sending a level up notification to user '%s'.", username), (Throwable)e);
        }
    }

    public String getContextPath() {
        return this.settingsManager.getGlobalSettings().getBaseUrl();
    }
}

