/*
 * Decompiled with CFR 0.152.
 */
package com.agileants.confluence.plugin.badge.services;

import com.agileants.confluence.plugin.badge.services.KeyValueService;
import com.atlassian.plugin.spring.scanner.annotation.imports.ConfluenceImport;
import com.atlassian.sal.api.pluginsettings.PluginSettings;
import com.atlassian.sal.api.pluginsettings.PluginSettingsFactory;
import javax.inject.Inject;
import javax.inject.Named;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Named
public class KeyValueServiceImpl
implements KeyValueService {
    private static final Logger logger = LoggerFactory.getLogger(KeyValueService.class);
    private static final String PLUGIN_NAME = "badge";
    private final PluginSettings pluginSettings;

    @Inject
    public KeyValueServiceImpl(@ConfluenceImport PluginSettingsFactory pluginSettingsFactory) {
        this.pluginSettings = pluginSettingsFactory.createGlobalSettings();
    }

    @Override
    public boolean isEnabled(String badgeId) {
        String key = String.format("%s.enabled", badgeId);
        String value = this.get(key);
        if (logger.isDebugEnabled()) {
            logger.debug("IsEnabled: Key'{}', value'{}'.", (Object)key, (Object)value);
        }
        return Boolean.parseBoolean(value);
    }

    @Override
    public void enable(String badgeId) {
        String key = String.format("%s.enabled", badgeId);
        this.put(key, Boolean.TRUE.toString());
        if (logger.isDebugEnabled()) {
            logger.debug("Enable: Key'{}', value'{}'.", (Object)key, (Object)Boolean.TRUE.toString());
        }
    }

    @Override
    public void disable(String badgeId) {
        String key = String.format("%s.enabled", badgeId);
        this.put(key, Boolean.FALSE.toString());
        if (logger.isDebugEnabled()) {
            logger.debug("Disable: Key'{}', value'{}'.", (Object)key, (Object)Boolean.FALSE.toString());
        }
    }

    @Override
    public void put(String key, String value) {
        this.pluginSettings.put(String.format("%s.%s", PLUGIN_NAME, key), (Object)value);
        if (logger.isDebugEnabled()) {
            logger.debug("Put: Key'{}', value'{}'.", (Object)key, (Object)value);
        }
    }

    @Override
    public String get(String key) {
        String value = (String)this.pluginSettings.get(String.format("%s.%s", PLUGIN_NAME, key));
        if (logger.isDebugEnabled()) {
            logger.debug("Get: Key'{}', value'{}'.", (Object)key, (Object)value);
        }
        return value == null ? "0" : value;
    }

    @Override
    public void remove(String key) {
        this.pluginSettings.remove(String.format("%s.%s", PLUGIN_NAME, key));
        if (logger.isDebugEnabled()) {
            logger.debug("Remove: Key'{}', value'{}'.", (Object)key, (Object)Boolean.TRUE.toString());
        }
    }
}

