/*
 * Decompiled with CFR 0.152.
 */
package com.agileants.confluence.plugin.badge.services;

import com.agileants.confluence.plugin.badge.activeobjects.FileAO;
import com.agileants.confluence.plugin.badge.services.FileService;
import com.atlassian.activeobjects.external.ActiveObjects;
import com.atlassian.plugin.spring.scanner.annotation.component.Scanned;
import com.atlassian.plugin.spring.scanner.annotation.imports.ComponentImport;
import com.atlassian.plugins.rest.common.multipart.FilePart;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import javax.inject.Inject;
import javax.inject.Named;
import net.java.ao.DBParam;
import net.java.ao.Query;
import net.java.ao.RawEntity;
import org.apache.commons.lang.NullArgumentException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Scanned
@Named
public class FileServiceImpl
implements FileService {
    private static final Logger logger = LoggerFactory.getLogger(FileServiceImpl.class);
    private static final int FILE_AO_LIMIT = 10000;
    @ComponentImport
    private final ActiveObjects ao;

    @Inject
    public FileServiceImpl(ActiveObjects ao) {
        this.ao = ao;
    }

    @Override
    public FileAO add(String name, String type, byte[] data) {
        FileAO fileAO = (FileAO)this.ao.create(FileAO.class, new DBParam[0]);
        fileAO.setName(name);
        fileAO.setType(type);
        fileAO.setData(data);
        fileAO.save();
        return fileAO;
    }

    @Override
    public FileAO add(FilePart filePart) throws IOException {
        FileAO result;
        block9: {
            result = null;
            try (InputStream input = filePart.getInputStream();){
                byte[] fileData = new byte[input.available()];
                input.read(fileData);
                if (fileData.length > 0) {
                    result = this.add(filePart.getName(), filePart.getContentType(), fileData);
                    break block9;
                }
                throw new NullArgumentException("File is empty.");
            }
            catch (IOException e) {
                logger.error(String.format("can't read filePart: '%s'.", filePart), (Throwable)e);
                throw new IOException("Could not read file.");
            }
        }
        return result;
    }

    @Override
    public FileAO get(int id) {
        return (FileAO)this.ao.get(FileAO.class, (Object)id);
    }

    @Override
    public void delete(int id) {
        this.ao.delete(new RawEntity[]{this.get(id)});
    }

    @Override
    public List<FileAO> all() {
        Query query = Query.select().limit(10000);
        return new ArrayList<FileAO>(Arrays.asList((FileAO[])this.ao.find(FileAO.class, query)));
    }
}

