/*
 * Decompiled with CFR 0.152.
 */
package com.agileants.confluence.plugin.badge.services;

import com.agileants.confluence.plugin.badge.activeobjects.EventAO;
import com.agileants.confluence.plugin.badge.objects.dto.EventRow;
import com.agileants.confluence.plugin.badge.services.EventService;
import com.atlassian.activeobjects.external.ActiveObjects;
import com.atlassian.plugin.spring.scanner.annotation.imports.ComponentImport;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import javax.inject.Inject;
import javax.inject.Named;
import net.java.ao.DBParam;
import net.java.ao.Query;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Named
public class EventServiceImpl
implements EventService {
    private static final Logger logger = LoggerFactory.getLogger(EventServiceImpl.class);
    private static final int EVENT_AO_LIMIT = 100000;
    @ComponentImport
    private final ActiveObjects ao;

    @Inject
    public EventServiceImpl(ActiveObjects ao) {
        this.ao = ao;
    }

    @Override
    public EventAO add(String className, long time) {
        return (EventAO)this.ao.create(EventAO.class, new DBParam[]{new DBParam("CLASS_NAME", (Object)className), new DBParam("TIME", (Object)time)});
    }

    @Override
    public List<EventAO> all() {
        Query query = Query.select().limit(100000);
        return new ArrayList<EventAO>(Arrays.asList((EventAO[])this.ao.find(EventAO.class, query)));
    }

    @Override
    public List<EventAO> getByTime(long from, long to, int limit) {
        EventAO[] eventAOs = (EventAO[])this.ao.find(EventAO.class, Query.select().where("TIME > ? AND TIME < ?", new Object[]{from, to}).limit(limit));
        ArrayList<EventAO> result = new ArrayList<EventAO>(Arrays.asList(eventAOs));
        return result;
    }

    @Override
    public List<EventRow> getEventsTable() {
        return EventServiceImpl.generateTable(this.all());
    }

    @Override
    public List<EventRow> getEventsTable(long from, long to) {
        return EventServiceImpl.generateTable(this.getByTime(from, to, 100000));
    }

    @Override
    public List<EventRow> getEventsTable(long from, long to, int limit) {
        List<EventRow> result = EventServiceImpl.generateTable(this.getByTime(from, to, 100000));
        return limit > result.size() ? result : result.subList(0, limit);
    }

    private static List<EventRow> generateTable(List<EventAO> events) {
        if (logger.isDebugEnabled()) {
            logger.debug(String.format("EVENTS: size: %d.", events.size()));
        }
        HashMap<String, EventRow> summarizedEvents = new HashMap<String, EventRow>();
        for (EventAO event : events) {
            String className = event.getClassName();
            if (logger.isDebugEnabled()) {
                logger.debug(String.format("Classname: '%s'.", className));
            }
            if (!summarizedEvents.containsKey(className)) {
                summarizedEvents.put(className, new EventRow(className, 0));
                if (logger.isDebugEnabled()) {
                    logger.debug(String.format("ADDED : '%s'.", className));
                }
            }
            ((EventRow)summarizedEvents.get(className)).incrementCount();
        }
        ArrayList<EventRow> result = new ArrayList<EventRow>(summarizedEvents.values());
        Collections.sort(result, Comparator.comparing(EventRow::getCount));
        Collections.reverse(result);
        return result;
    }

    @Override
    public void deleteAll() {
        this.ao.deleteWithSQL(EventAO.class, "TIME > 0", new Object[0]);
    }
}

