/*
 * Decompiled with CFR 0.152.
 */
package com.agileants.confluence.plugin.badge.services;

import com.agileants.confluence.plugin.badge.activeobjects.BadgeAO;
import com.agileants.confluence.plugin.badge.activeobjects.I18nAO;
import com.agileants.confluence.plugin.badge.managers.ListenerManager;
import com.agileants.confluence.plugin.badge.objects.dto.Badge;
import com.agileants.confluence.plugin.badge.services.BadgeService;
import com.agileants.confluence.plugin.badge.services.FileService;
import com.agileants.confluence.plugin.badge.services.UserService;
import com.agileants.confluence.plugin.badge.utils.BadgeUtils;
import com.atlassian.activeobjects.external.ActiveObjects;
import com.atlassian.confluence.setup.settings.SettingsManager;
import com.atlassian.plugin.spring.scanner.annotation.component.Scanned;
import com.atlassian.plugin.spring.scanner.annotation.imports.ConfluenceImport;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.stream.Collectors;
import javax.inject.Inject;
import javax.inject.Named;
import net.java.ao.DBParam;
import net.java.ao.Query;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Scanned
@Named
public class BadgeServiceImpl
implements BadgeService {
    private static final Logger logger = LoggerFactory.getLogger(BadgeServiceImpl.class);
    private final ActiveObjects ao;
    private final SettingsManager settingsManager;
    private final UserService userService;
    private final ListenerManager listenerManager;
    private final FileService fileService;
    private final String NOT_FOUND = "NOT FOUND";
    private final int BADGE_AO_LIMIT = 1000;

    @Inject
    public BadgeServiceImpl(@ConfluenceImport ActiveObjects ao, @ConfluenceImport SettingsManager settingsManager, UserService userService, ListenerManager listenerManager, FileService fileService) {
        if (ao == null) {
            throw new IllegalArgumentException("ao can't be null.");
        }
        if (settingsManager == null) {
            throw new IllegalArgumentException("settingsManager can't be null.");
        }
        if (userService == null) {
            throw new IllegalArgumentException("userService can't be null.");
        }
        if (listenerManager == null) {
            throw new IllegalArgumentException("listenerManager can't be null.");
        }
        if (fileService == null) {
            throw new IllegalArgumentException("fileService can't be null.");
        }
        this.ao = ao;
        this.settingsManager = settingsManager;
        this.userService = userService;
        this.listenerManager = listenerManager;
        this.fileService = fileService;
    }

    @Override
    public void update(BadgeAO newBadgeAO) {
        if (newBadgeAO == null) {
            throw new IllegalArgumentException("newBadgeAO can't be null.");
        }
        BadgeAO oldBadge = this.get(newBadgeAO.getID());
        this.updateListener(newBadgeAO.getID(), newBadgeAO.getEnabled());
        this.removeContextPath(newBadgeAO);
        newBadgeAO.save();
        if (oldBadge.getThresholdBronze() != newBadgeAO.getThresholdBronze() || oldBadge.getThresholdSilver() != newBadgeAO.getThresholdSilver() || oldBadge.getThresholdGold() != newBadgeAO.getThresholdGold()) {
            this.userService.recalculateLevels(newBadgeAO.getID(), newBadgeAO);
        }
    }

    @Override
    public void update(BadgeAO newBadgeAO, Locale locale, String name, String description) {
        if (newBadgeAO == null) {
            throw new IllegalArgumentException("newBadgeAO can't be null.");
        }
        this.setName(newBadgeAO.getID(), locale, name);
        this.setDesc(newBadgeAO.getID(), locale, description);
        this.update(newBadgeAO);
    }

    private BadgeAO add(String id, Locale locale, String name, String description, Boolean enabled, Integer thresholdBronze, Integer thresholdSilver, Integer thresholdGold, String bronzeImage, String silverImage, String goldImage, String neutralImage) {
        this.updateListener(id, enabled);
        this.ao.create(I18nAO.class, new DBParam[]{new DBParam("KEY", (Object)BadgeUtils.getKeyName(id)), new DBParam("LOCALE", (Object)locale.toString()), new DBParam("VALUE", (Object)name)});
        this.ao.create(I18nAO.class, new DBParam[]{new DBParam("KEY", (Object)BadgeUtils.getKeyDesc(id)), new DBParam("LOCALE", (Object)locale.toString()), new DBParam("VALUE", (Object)description)});
        return (BadgeAO)this.ao.create(BadgeAO.class, new DBParam[]{new DBParam("ID", (Object)id), new DBParam("ENABLED", (Object)enabled), new DBParam("THRESHOLD_BRONZE", (Object)thresholdBronze), new DBParam("THRESHOLD_SILVER", (Object)thresholdSilver), new DBParam("THRESHOLD_GOLD", (Object)thresholdGold), new DBParam("BRONZE_IMAGE", (Object)bronzeImage), new DBParam("SILVER_IMAGE", (Object)silverImage), new DBParam("GOLD_IMAGE", (Object)goldImage), new DBParam("NEUTRAL_IMAGE", (Object)neutralImage)});
    }

    @Override
    public BadgeAO add(Badge badge, Locale locale) {
        if (badge == null) {
            throw new IllegalArgumentException("badge can't be null.");
        }
        return this.add(badge.getId(), locale, badge.getName(), badge.getDescription(), badge.getEnabled(), badge.getThresholdBronze(), badge.getThresholdSilver(), badge.getThresholdGold(), badge.getBronzeImage(), badge.getSilverImage(), badge.getGoldImage(), badge.getNeutralImage());
    }

    @Override
    public BadgeAO get(String id) {
        BadgeAO badgeAO = (BadgeAO)this.ao.get(BadgeAO.class, (Object)id);
        this.addContextPath(badgeAO);
        return badgeAO;
    }

    @Override
    public void delete(String id) {
        if (logger.isDebugEnabled()) {
            logger.debug(String.format("delete id: '%s'.", id));
        }
        this.listenerManager.unregister(id);
        this.userService.deleteBadge(id);
        this.ao.deleteWithSQL(I18nAO.class, "KEY LIKE ?", new Object[]{id});
        BadgeAO badgeAO = this.get(id);
        if (badgeAO == null) {
            logger.error(String.format("cannot find badge with id: '%s'.", id));
            return;
        }
        if (badgeAO.getBronzeImage().contains("/rest/badge/1.0/file/image/")) {
            String bronzeImageId = badgeAO.getBronzeImage().split("/rest/badge/1.0/file/image/")[1];
            try {
                this.fileService.delete(Integer.parseInt(bronzeImageId));
            }
            catch (NumberFormatException e) {
                logger.error(String.format("cannot parse string to integer: '%s'.", bronzeImageId), (Throwable)e);
            }
        }
        if (badgeAO.getSilverImage().contains("/rest/badge/1.0/file/image/")) {
            String silverImageId = badgeAO.getSilverImage().split("/rest/badge/1.0/file/image/")[1];
            try {
                this.fileService.delete(Integer.parseInt(silverImageId));
            }
            catch (NumberFormatException e) {
                logger.error(String.format("cannot parse string to integer: '%s'.", silverImageId), (Throwable)e);
            }
        }
        if (badgeAO.getGoldImage().contains("/rest/badge/1.0/file/image/")) {
            String goldImageId = badgeAO.getGoldImage().split("/rest/badge/1.0/file/image/")[1];
            try {
                this.fileService.delete(Integer.parseInt(goldImageId));
            }
            catch (NumberFormatException e) {
                logger.error(String.format("cannot parse string to integer: '%s'.", goldImageId), (Throwable)e);
            }
        }
        if (badgeAO.getNeutralImage().contains("/rest/badge/1.0/file/image/")) {
            String neutralImageId = badgeAO.getNeutralImage().split("/rest/badge/1.0/file/image/")[1];
            try {
                this.fileService.delete(Integer.parseInt(neutralImageId));
            }
            catch (NumberFormatException e) {
                logger.error(String.format("cannot parse string to integer: '%s'.", neutralImageId), (Throwable)e);
            }
        }
        this.ao.deleteWithSQL(BadgeAO.class, "ID = ?", new Object[]{id});
    }

    @Override
    public List<BadgeAO> all() {
        if (logger.isDebugEnabled()) {
            logger.debug("all(): start..");
        }
        Query query = Query.select().limit(1000);
        ArrayList<BadgeAO> result = new ArrayList<BadgeAO>(Arrays.asList((BadgeAO[])this.ao.find(BadgeAO.class, query)));
        Collections.sort(result, Comparator.comparing(BadgeAO::getID));
        result.forEach(badgeAO -> this.addContextPath((BadgeAO)badgeAO));
        if (logger.isDebugEnabled()) {
            logger.debug("all(): DONE.");
        }
        return result;
    }

    @Override
    public Map<String, BadgeAO> allAsMap() {
        return this.all().stream().collect(Collectors.toMap(BadgeAO::getID, badgeAO -> badgeAO));
    }

    @Override
    public String getName(String id, Locale locale) {
        I18nAO result = this.getNameAO(id, locale);
        return result != null ? result.getValue() : "NOT FOUND";
    }

    private I18nAO getNameAO(String id, Locale locale) {
        I18nAO[] i18nAOS;
        if (logger.isDebugEnabled()) {
            logger.debug("LOCALE: " + locale.toString());
        }
        if ((i18nAOS = (I18nAO[])this.ao.find(I18nAO.class, Query.select().where("KEY = ? AND LOCALE = ?", new Object[]{BadgeUtils.getKeyName(id), locale.toString()}).limit(1))).length == 0) {
            i18nAOS = (I18nAO[])this.ao.find(I18nAO.class, Query.select().where("KEY = ? AND LOCALE = ?", new Object[]{BadgeUtils.getKeyName(id), Locale.ENGLISH.getLanguage()}).limit(1));
        }
        return i18nAOS.length > 0 ? i18nAOS[0] : null;
    }

    @Override
    public void setName(String id, Locale locale, String value) {
        I18nAO i18nAO = this.getNameAO(id, locale);
        if (i18nAO != null) {
            i18nAO.setValue(value);
            i18nAO.save();
        } else {
            String keyName = BadgeUtils.getKeyName(id);
            String localeParam = locale.toString();
            if (locale.getLanguage() == "en") {
                localeParam = "en";
            }
            this.ao.create(I18nAO.class, new DBParam[]{new DBParam("KEY", (Object)keyName), new DBParam("LOCALE", (Object)localeParam), new DBParam("VALUE", (Object)value)});
        }
    }

    @Override
    public String getDesc(String id, Locale locale) {
        I18nAO result = this.getDescAO(id, locale);
        return result != null ? result.getValue() : "NOT FOUND";
    }

    private I18nAO getDescAO(String id, Locale locale) {
        I18nAO[] i18nAOS = (I18nAO[])this.ao.find(I18nAO.class, Query.select().where("KEY = ? AND LOCALE = ?", new Object[]{BadgeUtils.getKeyDesc(id), locale.toString()}).limit(1));
        if (i18nAOS.length == 0) {
            i18nAOS = (I18nAO[])this.ao.find(I18nAO.class, Query.select().where("KEY = ? AND LOCALE = ?", new Object[]{BadgeUtils.getKeyDesc(id), Locale.ENGLISH.getLanguage()}).limit(1));
        }
        return i18nAOS.length > 0 ? i18nAOS[0] : null;
    }

    @Override
    public void setDesc(String id, Locale locale, String value) {
        I18nAO i18nAO = this.getDescAO(id, locale);
        if (i18nAO != null) {
            i18nAO.setValue(value);
            i18nAO.save();
        } else {
            String keyDesc = BadgeUtils.getKeyDesc(id);
            String localeParam = locale.toString();
            if (locale.getLanguage() == "en") {
                localeParam = "en";
            }
            this.ao.create(I18nAO.class, new DBParam[]{new DBParam("KEY", (Object)keyDesc), new DBParam("LOCALE", (Object)localeParam), new DBParam("VALUE", (Object)value)});
        }
    }

    private void updateListener(String id, Boolean enable) {
        if (enable != null && enable.booleanValue()) {
            this.listenerManager.enableListener(id);
        } else {
            this.listenerManager.disableListener(id);
        }
    }

    private void addContextPath(BadgeAO badgeAO) {
        if (badgeAO == null) {
            return;
        }
        String contextPath = this.settingsManager.getGlobalSettings().getBaseUrl();
        badgeAO.setBronzeImage(contextPath + badgeAO.getBronzeImage());
        badgeAO.setSilverImage(contextPath + badgeAO.getSilverImage());
        badgeAO.setGoldImage(contextPath + badgeAO.getGoldImage());
        badgeAO.setNeutralImage(contextPath + badgeAO.getNeutralImage());
    }

    public void removeContextPath(BadgeAO badgeAO) {
        String contextPath = this.settingsManager.getGlobalSettings().getBaseUrl();
        if (badgeAO.getBronzeImage().contains(contextPath)) {
            badgeAO.setBronzeImage(badgeAO.getBronzeImage().split(contextPath)[1]);
        }
        if (badgeAO.getSilverImage().contains(contextPath)) {
            badgeAO.setSilverImage(badgeAO.getSilverImage().split(contextPath)[1]);
        }
        if (badgeAO.getGoldImage().contains(contextPath)) {
            badgeAO.setGoldImage(badgeAO.getGoldImage().split(contextPath)[1]);
        }
        if (badgeAO.getNeutralImage().contains(contextPath)) {
            badgeAO.setNeutralImage(badgeAO.getNeutralImage().split(contextPath)[1]);
        }
    }
}

