/*
 * Decompiled with CFR 0.152.
 */
package com.agileants.confluence.plugin.badge.rest.test.data;

import com.agileants.confluence.plugin.badge.activeobjects.BadgeAO;
import com.agileants.confluence.plugin.badge.managers.LicenseManager;
import com.agileants.confluence.plugin.badge.objects.dto.Message;
import com.agileants.confluence.plugin.badge.objects.dto.UserBadge;
import com.agileants.confluence.plugin.badge.services.BadgeService;
import com.agileants.confluence.plugin.badge.services.UserService;
import com.agileants.confluence.plugin.badge.utils.BadgeUtils;
import com.agileants.confluence.plugin.badge.utils.UtilsMode;
import com.atlassian.annotations.security.XsrfProtectionExcluded;
import com.atlassian.confluence.security.PermissionManager;
import com.atlassian.confluence.setup.settings.SettingsManager;
import com.atlassian.confluence.user.ConfluenceUser;
import com.atlassian.confluence.user.UserAccessor;
import com.atlassian.plugin.spring.scanner.annotation.imports.ConfluenceImport;
import com.atlassian.user.EntityException;
import com.atlassian.user.Group;
import com.atlassian.user.GroupManager;
import com.atlassian.user.User;
import com.atlassian.user.impl.DefaultUser;
import com.atlassian.user.security.password.Credential;
import java.io.IOException;
import java.io.InputStream;
import java.time.Instant;
import java.util.List;
import javax.inject.Inject;
import javax.inject.Named;
import javax.servlet.http.HttpServletRequest;
import javax.ws.rs.Consumes;
import javax.ws.rs.GET;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.Response;
import org.apache.commons.io.IOUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Named
@Path(value="/test/data")
public class TestDataCreator {
    private static final Logger logger = LoggerFactory.getLogger(TestDataCreator.class);
    @ConfluenceImport
    private final UserAccessor userAccessor;
    @ConfluenceImport
    private final GroupManager groupManager;
    @ConfluenceImport
    private final PermissionManager permissionManager;
    private final LicenseManager licenseManager;
    private final BadgeService badgeService;
    private final UserService userService;
    private final Group groupDefault;

    @Inject
    public TestDataCreator(UserAccessor userAccessor, GroupManager groupManager, SettingsManager settingsManager, PermissionManager permissionManager, LicenseManager licenseManager, BadgeService badgeService, UserService userService) throws EntityException {
        if (userAccessor == null) {
            throw new IllegalArgumentException("userAccessor can't be null.");
        }
        if (groupManager == null) {
            throw new IllegalArgumentException("groupManager can't be null.");
        }
        if (settingsManager == null) {
            throw new IllegalArgumentException("settingsManager can't be null.");
        }
        if (permissionManager == null) {
            throw new IllegalArgumentException("permissionManager can't be null.");
        }
        if (licenseManager == null) {
            throw new IllegalArgumentException("licenseManager can't be null.");
        }
        if (badgeService == null) {
            throw new IllegalArgumentException("badgeService can't be null.");
        }
        if (userService == null) {
            throw new IllegalArgumentException("userService can't be null.");
        }
        this.userAccessor = userAccessor;
        this.groupManager = groupManager;
        this.permissionManager = permissionManager;
        this.licenseManager = licenseManager;
        this.badgeService = badgeService;
        this.userService = userService;
        String groupName = settingsManager.getGlobalSettings().getDefaultUsersGroup();
        if (logger.isDebugEnabled()) {
            logger.debug(String.format("group name: \"%s\".", groupName));
        }
        this.groupDefault = groupManager.getGroup(groupName);
        if (logger.isDebugEnabled()) {
            logger.debug(String.format("default group name: \"%s\".", this.groupDefault));
        }
    }

    private boolean checkAdmin(String userName) {
        return this.permissionManager.isConfluenceAdministrator((User)this.userAccessor.getUserByName(userName));
    }

    private Response checkAccess(HttpServletRequest request) {
        if (!this.licenseManager.checkLicense()) {
            logger.error("license has expired");
            return Response.status((Response.Status)Response.Status.FORBIDDEN).entity((Object)new Message("Badges for Confluence license has expired. Please purchase a new license to continue using Badges for Confluence.")).build();
        }
        if (!this.checkAdmin(request.getRemoteUser())) {
            logger.error(String.format("Unauthorized User request: '%s'.", request.getRemoteUser()));
            return Response.status((Response.Status)Response.Status.UNAUTHORIZED).build();
        }
        if (!UtilsMode.isDeveloper()) {
            logger.error("test data api not available.");
            return Response.status((Response.Status)Response.Status.NOT_FOUND).build();
        }
        return null;
    }

    @PUT
    @Path(value="/user")
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    @XsrfProtectionExcluded
    public Response createUsers(@Context HttpServletRequest request, @QueryParam(value="start") int start, @QueryParam(value="count") int count, @QueryParam(value="password") String password) throws IllegalArgumentException, EntityException {
        Response response = this.checkAccess(request);
        if (response != null) {
            return response;
        }
        for (int i = start; i < start + count; ++i) {
            String name = String.format("user_%06d", i);
            DefaultUser user = new DefaultUser(name);
            user.setEmail(String.format("%s@example.com", name));
            ConfluenceUser created = this.userAccessor.createUser((User)user, Credential.unencrypted((String)password));
            this.groupManager.addMembership(this.groupDefault, (User)created);
        }
        return Response.ok().entity((Object)new Message("Data is valid.")).build();
    }

    private void addUsersBadges(List<com.agileants.confluence.plugin.badge.objects.dto.User> users) {
        if (logger.isDebugEnabled()) {
            logger.debug("import user badges start..");
        }
        long time = System.currentTimeMillis();
        for (com.agileants.confluence.plugin.badge.objects.dto.User user : users) {
            for (UserBadge badge : user.getBadges()) {
                BadgeAO badgeAO = this.badgeService.get(badge.getId());
                if (badgeAO == null) {
                    logger.error(String.format("user '%s': can't find badge: '%s' -> ignore this data and continue work.", user.getUsername(), badge.getId()));
                    continue;
                }
                long userTime = time;
                if (badge.getTime() != null) {
                    userTime = Instant.parse(badge.getTime()).toEpochMilli();
                }
                String userKey = this.userAccessor.getUserByName(user.getUsername()).getKey().getStringValue();
                this.userService.add(userKey, badge.getId(), badge.getCount(), BadgeUtils.calculateLevel(badgeAO, badge.getCount()), userTime);
            }
        }
        if (logger.isDebugEnabled()) {
            logger.debug("import user badges DONE.");
        }
    }

    @PUT
    @Path(value="/user/badge")
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    @XsrfProtectionExcluded
    public Response importBadges(@Context HttpServletRequest request, List<com.agileants.confluence.plugin.badge.objects.dto.User> usersBadges) {
        Response response = this.checkAccess(request);
        if (response != null) {
            return response;
        }
        this.addUsersBadges(usersBadges);
        return Response.ok().build();
    }

    @GET
    @Path(value="/user/profilePicture/{id}")
    @Produces(value={"image/jpeg"})
    @XsrfProtectionExcluded
    public Response getProfilePicture(@Context HttpServletRequest request) throws IOException {
        byte[] image;
        Response response = this.checkAccess(request);
        if (response != null) {
            return response;
        }
        try (InputStream in = this.getClass().getResourceAsStream("/images/profile/guy-fawkes.jpg");){
            image = IOUtils.toByteArray((InputStream)in);
        }
        return Response.ok().type("image/jpeg").entity((Object)image).build();
    }
}

