/*
 * Decompiled with CFR 0.152.
 */
package com.agileants.confluence.plugin.badge.rest;

import com.agileants.confluence.plugin.badge.objects.dto.Message;
import com.agileants.confluence.plugin.badge.utils.Convert;
import com.atlassian.confluence.security.PermissionManager;
import com.atlassian.confluence.user.ConfluenceUser;
import com.atlassian.confluence.user.UserAccessor;
import com.atlassian.plugin.Plugin;
import com.atlassian.plugin.PluginAccessor;
import com.atlassian.plugin.PluginInformation;
import com.atlassian.plugin.spring.scanner.annotation.imports.ConfluenceImport;
import com.atlassian.user.User;
import javax.inject.Inject;
import javax.inject.Named;
import javax.servlet.http.HttpServletRequest;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.Response;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Named
@Path(value="/")
public class VersionRest {
    private static final Logger logger = LoggerFactory.getLogger(VersionRest.class);
    @ConfluenceImport
    private final UserAccessor userAccessor;
    @ConfluenceImport
    private final PermissionManager permissionManager;
    @ConfluenceImport
    private final PluginAccessor pluginAccessor;
    private final String PLUGIN_KEY = "com.agileants.confluence.plugin.badge";

    @Inject
    public VersionRest(UserAccessor userAccessor, PermissionManager permissionManager, PluginAccessor pluginAccessor) {
        if (userAccessor == null) {
            throw new IllegalArgumentException("userAccessor can't be null.");
        }
        if (permissionManager == null) {
            throw new IllegalArgumentException("permissionManager can't be null.");
        }
        if (pluginAccessor == null) {
            throw new IllegalArgumentException("pluginAccessor can't be null.");
        }
        this.userAccessor = userAccessor;
        this.permissionManager = permissionManager;
        this.pluginAccessor = pluginAccessor;
    }

    private boolean checkAdmin(HttpServletRequest request) {
        if (request == null) {
            logger.error("request is null.");
            return false;
        }
        String userName = request.getRemoteUser();
        if (Convert.isEmpty(userName)) {
            logger.error(String.format("userName is empty: '%s'.", userName));
            return false;
        }
        ConfluenceUser user = this.userAccessor.getUserByName(userName);
        if (user == null) {
            logger.error(String.format("can't find ConfluenceUser for userName: '%s'.", userName));
            return false;
        }
        return this.permissionManager.isConfluenceAdministrator((User)user);
    }

    @GET
    @Path(value="/version")
    @Produces(value={"application/json"})
    public Response getBadge(@Context HttpServletRequest request) {
        if (!this.checkAdmin(request)) {
            return Response.status((Response.Status)Response.Status.UNAUTHORIZED).build();
        }
        Plugin plugin = this.pluginAccessor.getPlugin("com.agileants.confluence.plugin.badge");
        if (plugin == null) {
            logger.error(String.format("can't get plugin for key: '%s'.", "com.agileants.confluence.plugin.badge"));
            return Response.status((Response.Status)Response.Status.INTERNAL_SERVER_ERROR).build();
        }
        PluginInformation info = plugin.getPluginInformation();
        if (info == null) {
            logger.error(String.format("can't get plugin information for key: '%s'.", "com.agileants.confluence.plugin.badge"));
            return Response.status((Response.Status)Response.Status.INTERNAL_SERVER_ERROR).build();
        }
        String version = info.getVersion();
        if (logger.isDebugEnabled()) {
            logger.debug(String.format("version: '%s'.", version));
        }
        return Response.ok().entity((Object)new Message(version)).build();
    }
}

