/*
 * Decompiled with CFR 0.152.
 */
package com.agileants.confluence.plugin.badge.rest;

import com.agileants.confluence.plugin.badge.activeobjects.BadgeAO;
import com.agileants.confluence.plugin.badge.activeobjects.UserAO;
import com.agileants.confluence.plugin.badge.enums.CalcMode;
import com.agileants.confluence.plugin.badge.enums.Error;
import com.agileants.confluence.plugin.badge.enums.Level;
import com.agileants.confluence.plugin.badge.managers.LicenseManager;
import com.agileants.confluence.plugin.badge.objects.dto.ErrorMessage;
import com.agileants.confluence.plugin.badge.objects.dto.Message;
import com.agileants.confluence.plugin.badge.objects.dto.UserBadge;
import com.agileants.confluence.plugin.badge.services.BadgeService;
import com.agileants.confluence.plugin.badge.services.IConfluenceUserSource;
import com.agileants.confluence.plugin.badge.services.NotificationService;
import com.agileants.confluence.plugin.badge.services.UserService;
import com.agileants.confluence.plugin.badge.services.impl.ConfluenceUserSource;
import com.agileants.confluence.plugin.badge.utils.BadgeUtils;
import com.agileants.confluence.plugin.badge.utils.Convert;
import com.agileants.confluence.plugin.badge.utils.UtilsMode;
import com.atlassian.annotations.security.XsrfProtectionExcluded;
import com.atlassian.confluence.languages.LocaleManager;
import com.atlassian.confluence.security.PermissionManager;
import com.atlassian.confluence.setup.settings.SettingsManager;
import com.atlassian.confluence.user.ConfluenceUser;
import com.atlassian.confluence.user.UserAccessor;
import com.atlassian.plugin.spring.scanner.annotation.imports.ConfluenceImport;
import com.atlassian.sal.api.message.I18nResolver;
import com.atlassian.user.User;
import java.io.Serializable;
import java.time.Instant;
import java.time.format.DateTimeParseException;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.inject.Inject;
import javax.inject.Named;
import javax.servlet.http.HttpServletRequest;
import javax.ws.rs.Consumes;
import javax.ws.rs.DELETE;
import javax.ws.rs.GET;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.Response;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Named
@Path(value="/users")
public class UserRest {
    private static final Logger logger = LoggerFactory.getLogger(UserRest.class);
    @ConfluenceImport
    private final UserAccessor userAccessor;
    @ConfluenceImport
    private final PermissionManager permissionManager;
    @ConfluenceImport
    private final I18nResolver i18n;
    @ConfluenceImport
    private final LocaleManager localeManager;
    @ConfluenceImport
    private final SettingsManager settingsManager;
    private final LicenseManager licenseManager;
    private final BadgeService badgeService;
    private final UserService userService;
    private final NotificationService notificationService;
    private final IConfluenceUserSource confluenceUserSource;

    @Inject
    public UserRest(UserAccessor userAccessor, PermissionManager permissionManager, I18nResolver i18n, LocaleManager localeManager, SettingsManager settingsManager, LicenseManager licenseManager, BadgeService badgeService, UserService userService, NotificationService notificationService) {
        if (userAccessor == null) {
            throw new IllegalArgumentException("userAccessor can't be null.");
        }
        if (permissionManager == null) {
            throw new IllegalArgumentException("permissionManager can't be null.");
        }
        if (i18n == null) {
            throw new IllegalArgumentException("i18n can't be null.");
        }
        if (localeManager == null) {
            throw new IllegalArgumentException("localeManager can't be null.");
        }
        if (settingsManager == null) {
            throw new IllegalArgumentException("settingsManager can't be null.");
        }
        if (licenseManager == null) {
            throw new IllegalArgumentException("licenseManager can't be null.");
        }
        if (badgeService == null) {
            throw new IllegalArgumentException("badgeService can't be null.");
        }
        if (userService == null) {
            throw new IllegalArgumentException("userService can't be null.");
        }
        if (notificationService == null) {
            throw new IllegalArgumentException("notificationService can't be null.");
        }
        this.userAccessor = userAccessor;
        this.permissionManager = permissionManager;
        this.i18n = i18n;
        this.localeManager = localeManager;
        this.settingsManager = settingsManager;
        this.licenseManager = licenseManager;
        this.badgeService = badgeService;
        this.userService = userService;
        this.notificationService = notificationService;
        this.confluenceUserSource = ConfluenceUserSource.get(this.userAccessor, this.settingsManager, this.userService);
    }

    private boolean checkAdmin(HttpServletRequest request) {
        if (request == null) {
            logger.error("request is null.");
            return false;
        }
        String username = request.getRemoteUser();
        if (Convert.isEmpty(username)) {
            logger.error(String.format("userName is empty: '%s'.", username));
            return false;
        }
        ConfluenceUser user = this.confluenceUserSource.getUserByName(username);
        if (user == null) {
            logger.error(String.format("can't find ConfluenceUser for userName: '%s'.", username));
            return false;
        }
        return this.permissionManager.isConfluenceAdministrator((User)user);
    }

    private Response checkAccess(HttpServletRequest request) {
        if (!this.licenseManager.checkLicense()) {
            logger.error("license has expired.");
            return Response.status((Response.Status)Response.Status.FORBIDDEN).entity((Object)new Message("Badges for Confluence license has expired. Please purchase a new license to continue using Badges for Confluence.")).build();
        }
        if (!this.checkAdmin(request)) {
            logger.error(String.format("Unauthorized User request: '%s'.", request.getRemoteUser()));
            return Response.status((Response.Status)Response.Status.UNAUTHORIZED).build();
        }
        return null;
    }

    private boolean checkUserExists(String username) {
        ConfluenceUser user = this.confluenceUserSource.getUserByName(username);
        return user != null;
    }

    private boolean checkBadgeExists(String badgeId) {
        BadgeAO badgeAO = this.badgeService.get(badgeId);
        return badgeAO != null;
    }

    private static CalcMode calcModeToEnum(String calcMode) {
        if (calcMode == null) {
            return CalcMode.NONE;
        }
        if ("add".equals(calcMode)) {
            return CalcMode.ADD;
        }
        if ("remove".equals(calcMode)) {
            return CalcMode.REMOVE;
        }
        return CalcMode.NONE;
    }

    private void validate(List<com.agileants.confluence.plugin.badge.objects.dto.User> users, CalcMode calcMode, List<ErrorMessage> errors) {
        if (logger.isInfoEnabled()) {
            logger.info("validate start..");
        }
        for (com.agileants.confluence.plugin.badge.objects.dto.User user : users) {
            if (!UtilsMode.isDeveloper() && !this.checkUserExists(user.getUsername())) {
                logger.error(String.format("user: '%s' not exists.", user.getUsername()));
                List<com.agileants.confluence.plugin.badge.objects.dto.User> src = Stream.of(new com.agileants.confluence.plugin.badge.objects.dto.User(user.getUsername())).collect(Collectors.toList());
                errors.add(new ErrorMessage(Error.USER_NOT_FOUND).username(user.getUsername()).src(src));
            }
            for (UserBadge badge : user.getBadges()) {
                int newCount;
                List<com.agileants.confluence.plugin.badge.objects.dto.User> src;
                if (!this.checkBadgeExists(badge.getId())) {
                    logger.error(String.format("badge: '%s' not exists.", badge.getId()));
                    src = Stream.of(new com.agileants.confluence.plugin.badge.objects.dto.User(user.getUsername(), badge)).collect(Collectors.toList());
                    errors.add(new ErrorMessage(Error.BADGE_NOT_FOUND).badgeId(badge.getId()).src(src));
                }
                if (badge.getCount() < 1) {
                    logger.error(String.format("invalid count: %d.", badge.getCount()));
                    src = Stream.of(new com.agileants.confluence.plugin.badge.objects.dto.User(user.getUsername(), badge)).collect(Collectors.toList());
                    errors.add(new ErrorMessage(Error.COUNT_INVALID).count(badge.getCount()).src(src));
                }
                if (badge.getTime() != null) {
                    try {
                        Instant.parse(badge.getTime()).toEpochMilli();
                    }
                    catch (DateTimeParseException ex) {
                        logger.error(String.format("invalid time: '%s'.", badge.getTime()), (Throwable)ex);
                        List<com.agileants.confluence.plugin.badge.objects.dto.User> src2 = Stream.of(new com.agileants.confluence.plugin.badge.objects.dto.User(user.getUsername(), badge)).collect(Collectors.toList());
                        errors.add(new ErrorMessage(Error.TIME_INVALID).time(badge.getTime()).src(src2));
                    }
                }
                if (!this.checkUserExists(user.getUsername())) continue;
                String userKey = this.confluenceUserSource.getUserByName(user.getUsername()).getKey().getStringValue();
                int oldCount = this.userService.getCount(userKey, badge.getId());
                switch (calcMode) {
                    case ADD: {
                        newCount = oldCount + badge.getCount();
                        break;
                    }
                    case REMOVE: {
                        newCount = oldCount - badge.getCount();
                        break;
                    }
                    default: {
                        newCount = badge.getCount();
                    }
                }
                if (newCount >= 0) continue;
                logger.error(String.format("invalid new count: '%d'.", newCount));
                List<com.agileants.confluence.plugin.badge.objects.dto.User> src3 = Stream.of(new com.agileants.confluence.plugin.badge.objects.dto.User(user.getUsername(), badge)).collect(Collectors.toList());
                errors.add(new ErrorMessage(Error.NEW_COUNT_INVALID).newCount(newCount).src(src3));
            }
        }
        if (logger.isInfoEnabled()) {
            logger.info("validate DONE.");
        }
    }

    private List<com.agileants.confluence.plugin.badge.objects.dto.User> addUsersBadges(List<com.agileants.confluence.plugin.badge.objects.dto.User> users, List<ErrorMessage> errors, CalcMode calcMode, boolean notification) {
        ArrayList<com.agileants.confluence.plugin.badge.objects.dto.User> result = new ArrayList<com.agileants.confluence.plugin.badge.objects.dto.User>();
        if (logger.isDebugEnabled()) {
            logger.debug("import user badges: start..");
        }
        ArrayList<ErrorMessage> err = new ArrayList<ErrorMessage>();
        this.validate(users, calcMode, err);
        if (0 < err.size()) {
            errors.addAll(err);
            return result;
        }
        long time = System.currentTimeMillis();
        for (com.agileants.confluence.plugin.badge.objects.dto.User user : users) {
            for (UserBadge badge : user.getBadges()) {
                com.agileants.confluence.plugin.badge.objects.dto.User userResult;
                int newCount;
                if (logger.isDebugEnabled()) {
                    logger.debug(String.format("import for userName: '%s', badge: '%s'.", user.getUsername(), badge.getId()));
                }
                String userKey = this.confluenceUserSource.getUserByName(user.getUsername()).getKey().getStringValue();
                BadgeAO badgeAO = this.badgeService.get(badge.getId());
                if (badgeAO == null) {
                    throw new NullPointerException(String.format("BadgeAO '%s'could not be found.", badge.getId()));
                }
                long userTime = time;
                if (badge.getTime() != null) {
                    userTime = Instant.parse(badge.getTime()).toEpochMilli();
                }
                int oldCount = this.userService.getCount(userKey, badge.getId());
                switch (calcMode) {
                    case ADD: {
                        newCount = oldCount + badge.getCount();
                        break;
                    }
                    case REMOVE: {
                        newCount = oldCount - badge.getCount();
                        break;
                    }
                    default: {
                        newCount = badge.getCount();
                    }
                }
                Level newLevel = BadgeUtils.calculateLevel(badgeAO, newCount);
                UserAO newUserAO = this.userService.add(userKey, badge.getId(), newCount, newLevel, userTime);
                if (notification && BadgeUtils.checkLevelUp(badgeAO, oldCount, newCount)) {
                    this.notificationService.levelUp(userKey, badge.getId(), newLevel);
                }
                if ((userResult = (com.agileants.confluence.plugin.badge.objects.dto.User)result.stream().filter(o -> user.getUsername().equals(o.getUsername())).findAny().orElse(null)) == null) {
                    userResult = new com.agileants.confluence.plugin.badge.objects.dto.User(this.confluenceUserSource.getUserByKey(newUserAO.getUserKey()).getName());
                    result.add(userResult);
                }
                userResult.getBadges().add(new UserBadge(newUserAO.getBadgeID(), newUserAO.getCount(), newUserAO.getTime()));
            }
        }
        if (logger.isDebugEnabled()) {
            logger.debug("import user badges: DONE.");
        }
        return result;
    }

    @PUT
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    @XsrfProtectionExcluded
    public Response updateUserBadges(@QueryParam(value="report") boolean report, @QueryParam(value="calcMode") String calcMode, @QueryParam(value="notification") boolean notification, @QueryParam(value="username") String username, @QueryParam(value="badgeId") String badgeId, List<com.agileants.confluence.plugin.badge.objects.dto.User> usersBadges, @Context HttpServletRequest request) {
        Response response = this.checkAccess(request);
        if (response != null) {
            return response;
        }
        if (username != null) {
            return Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)new ErrorMessage(Error.PARAMETER_UNSUPPORTED).parameter("username")).build();
        }
        if (badgeId != null) {
            return Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)new ErrorMessage(Error.PARAMETER_UNSUPPORTED).parameter("badgeId")).build();
        }
        if (logger.isInfoEnabled()) {
            logger.info("import user badges: start..");
        }
        ArrayList<ErrorMessage> errors = new ArrayList<ErrorMessage>();
        List<com.agileants.confluence.plugin.badge.objects.dto.User> result = this.addUsersBadges(usersBadges, errors, UserRest.calcModeToEnum(calcMode), notification);
        if (!errors.isEmpty()) {
            return Response.status((Response.Status)Response.Status.BAD_REQUEST).entity(errors).build();
        }
        if (logger.isInfoEnabled()) {
            logger.info("import user badges: DONE.");
        }
        return report ? Response.ok().entity(result).build() : Response.ok().build();
    }

    @PUT
    @Path(value="/validate")
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    @XsrfProtectionExcluded
    public Response validateUserBadges(@QueryParam(value="calcMode") String calcMode, @QueryParam(value="username") String username, @QueryParam(value="badgeId") String badgeId, List<com.agileants.confluence.plugin.badge.objects.dto.User> usersBadges, @Context HttpServletRequest request) {
        Response response = this.checkAccess(request);
        if (response != null) {
            return response;
        }
        if (username != null) {
            return Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)new ErrorMessage(Error.PARAMETER_UNSUPPORTED).parameter("username")).build();
        }
        if (badgeId != null) {
            return Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)new ErrorMessage(Error.PARAMETER_UNSUPPORTED).parameter("badgeId")).build();
        }
        if (logger.isInfoEnabled()) {
            logger.info("validation of import user badges: start..");
        }
        ArrayList<ErrorMessage> errors = new ArrayList<ErrorMessage>();
        this.validate(usersBadges, UserRest.calcModeToEnum(calcMode), errors);
        if (!errors.isEmpty()) {
            return Response.status((Response.Status)Response.Status.BAD_REQUEST).entity(errors).build();
        }
        if (logger.isInfoEnabled()) {
            logger.info("validation of import user badges: DONE.");
        }
        return Response.ok().entity((Object)new Message("Data is valid.")).build();
    }

    @GET
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    @XsrfProtectionExcluded
    public Response getUserBadges(@QueryParam(value="username") String username, @QueryParam(value="badgeId") String badgeId, @Context HttpServletRequest request) {
        Response response = this.checkAccess(request);
        if (response != null) {
            return response;
        }
        if (logger.isInfoEnabled()) {
            logger.info("export user badges: start..");
        }
        List<Object> userAOList = new ArrayList();
        if (username != null) {
            if (!this.checkUserExists(username)) {
                return Response.status((Response.Status)Response.Status.NOT_FOUND).entity((Object)new ErrorMessage(Error.USER_NOT_FOUND).username(username)).build();
            }
            if (badgeId != null) {
                if (!this.checkBadgeExists(badgeId)) {
                    return Response.status((Response.Status)Response.Status.NOT_FOUND).entity((Object)new ErrorMessage(Error.BADGE_NOT_FOUND).badgeId(badgeId)).build();
                }
                UserAO userAO = this.userService.find(this.confluenceUserSource.getUserByName(username).getKey().getStringValue(), badgeId);
                if (userAO != null) {
                    userAOList.add(userAO);
                }
            } else {
                userAOList = this.userService.allByUser(this.confluenceUserSource.getUserByName(username).getKey().getStringValue());
            }
        } else if (badgeId != null) {
            if (!this.checkBadgeExists(badgeId)) {
                return Response.status((Response.Status)Response.Status.NOT_FOUND).entity((Object)new ErrorMessage(Error.BADGE_NOT_FOUND).badgeId(badgeId)).build();
            }
            userAOList = this.userService.allByBadge(badgeId);
        } else {
            userAOList = this.userService.all();
        }
        ArrayList<com.agileants.confluence.plugin.badge.objects.dto.User> userList = new ArrayList<com.agileants.confluence.plugin.badge.objects.dto.User>();
        for (UserAO userAO : userAOList) {
            String userKey = userAO.getUserKey();
            ConfluenceUser confluenceUser = this.confluenceUserSource.getUserByKey(userKey);
            String usernameTemp = confluenceUser != null ? confluenceUser.getName() : userKey;
            com.agileants.confluence.plugin.badge.objects.dto.User user = userList.stream().filter(o -> usernameTemp.equals(o.getUsername())).findAny().orElse(null);
            if (user == null) {
                user = new com.agileants.confluence.plugin.badge.objects.dto.User(usernameTemp);
                userList.add(user);
            }
            user.getBadges().add(new UserBadge(userAO.getBadgeID(), userAO.getCount(), userAO.getTime()));
        }
        if (logger.isInfoEnabled()) {
            logger.info("export user badges: DONE.");
        }
        return Response.ok(userList).build();
    }

    @DELETE
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    @XsrfProtectionExcluded
    public Response deleteUserBadges(@QueryParam(value="username") String username, @QueryParam(value="badgeId") String badgeId, @Context HttpServletRequest request) {
        Response response = this.checkAccess(request);
        if (response != null) {
            return response;
        }
        if (logger.isInfoEnabled()) {
            logger.info("delete user badges: start..");
        }
        Message message = null;
        if (username != null) {
            if (!this.checkUserExists(username)) {
                return Response.status((Response.Status)Response.Status.NOT_FOUND).entity((Object)new ErrorMessage(Error.USER_NOT_FOUND).username(username)).build();
            }
            if (badgeId != null) {
                if (!this.checkBadgeExists(badgeId)) {
                    return Response.status((Response.Status)Response.Status.NOT_FOUND).entity((Object)new ErrorMessage(Error.BADGE_NOT_FOUND).badgeId(badgeId)).build();
                }
                this.userService.deleteUserBadge(this.confluenceUserSource.getUserByName(username).getKey().getStringValue(), badgeId);
            } else {
                this.userService.deleteUser(this.confluenceUserSource.getUserByName(username).getKey().getStringValue());
            }
        } else if (badgeId != null) {
            if (!this.checkBadgeExists(badgeId)) {
                return Response.status((Response.Status)Response.Status.NOT_FOUND).entity((Object)new ErrorMessage(Error.BADGE_NOT_FOUND).badgeId(badgeId)).build();
            }
            this.userService.deleteBadge(badgeId);
            String badgeName = this.badgeService.getName(badgeId, this.localeManager.getLocale((User)this.confluenceUserSource.getUserByName(request.getRemoteUser())));
            message = new Message(this.i18n.getText("badges.remove.badge", new Serializable[]{badgeName}));
        } else {
            this.userService.deleteAll();
            message = new Message(this.i18n.getText("badges.remove.all.badges"));
        }
        if (logger.isInfoEnabled()) {
            logger.info("delete user badges: DONE.");
        }
        return message == null ? Response.ok().build() : Response.ok((Object)message).build();
    }
}

