/*
 * Decompiled with CFR 0.152.
 */
package com.agileants.confluence.plugin.badge.rest;

import com.agileants.confluence.plugin.badge.activeobjects.FileAO;
import com.agileants.confluence.plugin.badge.objects.dto.Message;
import com.agileants.confluence.plugin.badge.services.FileService;
import com.agileants.confluence.plugin.badge.utils.Convert;
import com.atlassian.annotations.security.XsrfProtectionExcluded;
import com.atlassian.confluence.security.PermissionManager;
import com.atlassian.confluence.user.ConfluenceUser;
import com.atlassian.confluence.user.UserAccessor;
import com.atlassian.plugin.spring.scanner.annotation.imports.ConfluenceImport;
import com.atlassian.plugins.rest.common.multipart.FilePart;
import com.atlassian.plugins.rest.common.multipart.MultipartFormParam;
import com.atlassian.user.User;
import java.io.IOException;
import java.io.InputStream;
import javax.inject.Inject;
import javax.inject.Named;
import javax.servlet.http.HttpServletRequest;
import javax.ws.rs.Consumes;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.Response;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Named
@Path(value="/file")
public class FileRest {
    private static final Logger logger = LoggerFactory.getLogger(FileRest.class);
    public static final String baseUrl = "/rest/badge/1.0/file/";
    public static final String urlImage = "/rest/badge/1.0/file/image/";
    private final UserAccessor userAccessor;
    private final FileService fileService;
    @ConfluenceImport
    private final PermissionManager permissionManager;

    @Inject
    public FileRest(UserAccessor userAccessor, FileService fileService, PermissionManager permissionManager) {
        if (userAccessor == null) {
            throw new IllegalArgumentException("userAccessor can't be null.");
        }
        if (fileService == null) {
            throw new IllegalArgumentException("fileService can't be null.");
        }
        if (permissionManager == null) {
            throw new IllegalArgumentException("permissionManager can't be null.");
        }
        this.userAccessor = userAccessor;
        this.fileService = fileService;
        this.permissionManager = permissionManager;
    }

    @GET
    @Path(value="/text/{id}")
    @Produces(value={"text/plain"})
    public Response getText(@PathParam(value="id") int id, @Context HttpServletRequest request) {
        if (!this.checkAdmin(request)) {
            return Response.status((Response.Status)Response.Status.UNAUTHORIZED).build();
        }
        return this.getFile(id);
    }

    @POST
    @Path(value="/text")
    @Consumes(value={"multipart/form-data"})
    @Produces(value={"application/json", "text/plain"})
    @XsrfProtectionExcluded
    public Response uploadText(@MultipartFormParam(value="text") FilePart filePart, @Context HttpServletRequest request) {
        if (!this.checkAdmin(request)) {
            return Response.status((Response.Status)Response.Status.UNAUTHORIZED).build();
        }
        return this.uploadFile(filePart);
    }

    @GET
    @Path(value="/image/{id}")
    @Produces(value={"image/svg", "image/svg+xml", "image/png", "image/jpeg"})
    public Response getImage(@PathParam(value="id") int id, @Context HttpServletRequest request) {
        return this.getFile(id);
    }

    @POST
    @Path(value="/image")
    @Consumes(value={"multipart/form-data"})
    @Produces(value={"application/json", "text/plain"})
    @XsrfProtectionExcluded
    public Response uploadImage(@MultipartFormParam(value="image") FilePart filePart, @Context HttpServletRequest request) {
        if (!this.checkAdmin(request)) {
            return Response.status((Response.Status)Response.Status.UNAUTHORIZED).build();
        }
        return this.uploadFile(filePart);
    }

    private boolean checkAdmin(HttpServletRequest request) {
        if (request == null) {
            logger.error("request is null.");
            return false;
        }
        String userName = request.getRemoteUser();
        if (Convert.isEmpty(userName)) {
            logger.error(String.format("userName is empty: '%s'.", userName));
            return false;
        }
        ConfluenceUser user = this.userAccessor.getUserByName(userName);
        if (user == null) {
            logger.error(String.format("can't find ConfluenceUser for userName: '%s'.", userName));
            return false;
        }
        return this.permissionManager.isConfluenceAdministrator((User)user);
    }

    private Response uploadFile(FilePart filePart) {
        String fileName = filePart.getName().split("\\.")[0];
        return this.uploadFile(filePart, fileName);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private Response uploadFile(FilePart filePart, String fileName) {
        if (logger.isDebugEnabled()) {
            logger.debug("UploadFile Name: '{}', ContentType: '{}', Size: '{}'.", new Object[]{fileName, filePart.getContentType(), filePart.getSize()});
        }
        try (InputStream input = filePart.getInputStream();){
            byte[] fileData = new byte[input.available()];
            input.read(fileData);
            if (fileData.length <= 0) {
                logger.error(String.format("No Content found in file '%s'.", fileName));
                Response throwable = Response.status((Response.Status)Response.Status.NO_CONTENT).build();
                return throwable;
            }
            this.fileService.add(fileName, filePart.getContentType(), fileData);
            return Response.ok((Object)new Message(String.format("File(s) uploaded: '%s'.", filePart.getName()))).build();
        }
        catch (IOException e) {
            String message = String.format("can't read file: '%s'.", fileName);
            logger.error(message, (Throwable)e);
            return Response.status((Response.Status)Response.Status.INTERNAL_SERVER_ERROR).entity((Object)new Message(message)).build();
        }
    }

    private Response getFile(int id) {
        FileAO fileAO = this.fileService.get(id);
        if (fileAO == null) {
            String message = String.format("No File found with id: %d.", id);
            logger.error(message);
            return Response.status((Response.Status)Response.Status.NOT_FOUND).entity((Object)message).build();
        }
        return Response.ok((Object)fileAO.getData(), (String)fileAO.getType()).build();
    }
}

