/*
 * Decompiled with CFR 0.152.
 */
package com.agileants.confluence.plugin.badge.rest;

import com.agileants.confluence.plugin.badge.listener.confluence.ConfluenceEventListener;
import com.agileants.confluence.plugin.badge.objects.dto.EventRow;
import com.agileants.confluence.plugin.badge.objects.dto.Message;
import com.agileants.confluence.plugin.badge.services.EventService;
import com.agileants.confluence.plugin.badge.utils.DateUtils;
import com.atlassian.confluence.api.service.accessmode.ReadOnlyAccessBlocked;
import com.atlassian.confluence.security.PermissionManager;
import com.atlassian.confluence.user.UserAccessor;
import com.atlassian.plugin.spring.scanner.annotation.imports.ConfluenceImport;
import com.atlassian.user.User;
import java.util.List;
import javax.inject.Inject;
import javax.inject.Named;
import javax.servlet.http.HttpServletRequest;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.Response;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Named
@Path(value="/confListener")
public class ConfluenceListenerRest {
    private static final Logger log = LoggerFactory.getLogger(ConfluenceListenerRest.class);
    private final ConfluenceEventListener confluenceEventListener;
    private final EventService eventService;
    @ConfluenceImport
    private final PermissionManager permissionManager;
    @ConfluenceImport
    private final UserAccessor userAccessor;

    @Inject
    public ConfluenceListenerRest(ConfluenceEventListener confluenceEventListener, EventService eventService, PermissionManager permissionManager, UserAccessor userAccessor) {
        this.confluenceEventListener = confluenceEventListener;
        this.eventService = eventService;
        this.permissionManager = permissionManager;
        this.userAccessor = userAccessor;
    }

    @GET
    @ReadOnlyAccessBlocked
    @Path(value="/disable")
    @Produces(value={"application/json"})
    public Response disable(@Context HttpServletRequest request) {
        if (!this.checkAdmin(request.getRemoteUser())) {
            log.error("Unauthorized User request: '{}'.", (Object)request.getRemoteUser());
            return Response.status((Response.Status)Response.Status.UNAUTHORIZED).build();
        }
        this.confluenceEventListener.disable();
        return Response.ok((Object)new Message("disabled")).build();
    }

    @GET
    @ReadOnlyAccessBlocked
    @Path(value="/enable")
    @Produces(value={"application/json"})
    public Response enable(@Context HttpServletRequest request) {
        if (!this.checkAdmin(request.getRemoteUser())) {
            log.error("Unauthorized User request: '{}'.", (Object)request.getRemoteUser());
            return Response.status((Response.Status)Response.Status.UNAUTHORIZED).build();
        }
        this.confluenceEventListener.enable();
        return Response.ok((Object)new Message("enabled")).build();
    }

    private boolean checkAdmin(String userName) {
        return this.permissionManager.isConfluenceAdministrator((User)this.userAccessor.getUserByName(userName));
    }

    @GET
    @ReadOnlyAccessBlocked
    @Path(value="/deleteAll")
    @Produces(value={"application/json"})
    public Response deleteAll(@Context HttpServletRequest request) {
        if (!this.checkAdmin(request.getRemoteUser())) {
            log.error("Unauthorized User request: '{}'.", (Object)request.getRemoteUser());
            return Response.status((Response.Status)Response.Status.UNAUTHORIZED).build();
        }
        this.eventService.deleteAll();
        return Response.ok((Object)new Message("all deleted")).build();
    }

    @GET
    @Path(value="/eventsTable")
    @Produces(value={"application/json"})
    public Response getEventsTable(@QueryParam(value="from") long from, @QueryParam(value="to") long to, @QueryParam(value="limit") int limit, @Context HttpServletRequest request) {
        if (!this.checkAdmin(request.getRemoteUser())) {
            log.error("Unauthorized User request: '{}'.", (Object)request.getRemoteUser());
            return Response.status((Response.Status)Response.Status.UNAUTHORIZED).build();
        }
        List<EventRow> result = limit < 1 ? this.eventService.getEventsTable(from, to) : this.eventService.getEventsTable(from, to, limit);
        return Response.ok(result).build();
    }

    @GET
    @ReadOnlyAccessBlocked
    @Path(value="/testdata")
    @Produces(value={"application/json"})
    public Response testdata(@Context HttpServletRequest request) {
        if (!this.checkAdmin(request.getRemoteUser())) {
            log.error("Unauthorized User request: '{}'.", (Object)request.getRemoteUser());
            return Response.status((Response.Status)Response.Status.UNAUTHORIZED).build();
        }
        for (int i = 0; i < 110; ++i) {
            this.eventService.add("event_" + i, DateUtils.daysBackInMillis(i % 11));
        }
        return Response.ok((Object)new Message("testdata generated")).build();
    }
}

