/*
 * Decompiled with CFR 0.152.
 */
package com.agileants.confluence.plugin.badge.rest;

import com.agileants.confluence.plugin.badge.activeobjects.BadgeAO;
import com.agileants.confluence.plugin.badge.objects.dto.Badge;
import com.agileants.confluence.plugin.badge.objects.dto.Message;
import com.agileants.confluence.plugin.badge.services.BadgeService;
import com.agileants.confluence.plugin.badge.services.FileService;
import com.agileants.confluence.plugin.badge.utils.BadgeUtils;
import com.atlassian.annotations.security.XsrfProtectionExcluded;
import com.atlassian.confluence.api.service.accessmode.ReadOnlyAccessBlocked;
import com.atlassian.confluence.languages.LocaleManager;
import com.atlassian.confluence.security.PermissionManager;
import com.atlassian.confluence.setup.settings.SettingsManager;
import com.atlassian.confluence.user.UserAccessor;
import com.atlassian.plugin.spring.scanner.annotation.imports.ConfluenceImport;
import com.atlassian.plugins.rest.common.multipart.FilePart;
import com.atlassian.plugins.rest.common.multipart.MultipartFormParam;
import com.atlassian.sal.api.message.I18nResolver;
import com.atlassian.user.User;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import javax.inject.Inject;
import javax.inject.Named;
import javax.servlet.http.HttpServletRequest;
import javax.ws.rs.Consumes;
import javax.ws.rs.DELETE;
import javax.ws.rs.GET;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.Response;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Named
@Path(value="/badges")
public class BadgeRest {
    private static final Logger logger = LoggerFactory.getLogger(BadgeRest.class);
    private final UserAccessor userAccessor;
    private final BadgeService badgeService;
    private final FileService fileService;
    private final I18nResolver i18n;
    private final LocaleManager localeManager;
    @ConfluenceImport
    private final PermissionManager permissionManager;
    @ConfluenceImport
    private final SettingsManager settingsManager;

    @Inject
    public BadgeRest(UserAccessor userAccessor, BadgeService badgeService, FileService fileService, I18nResolver i18n, LocaleManager localeManager, PermissionManager permissionManager, SettingsManager settingsManager) {
        this.userAccessor = userAccessor;
        this.badgeService = badgeService;
        this.fileService = fileService;
        this.i18n = i18n;
        this.localeManager = localeManager;
        this.permissionManager = permissionManager;
        this.settingsManager = settingsManager;
    }

    public static boolean checkThresholdsOrder(int bronze, int silver, int gold) {
        return bronze < silver && silver < gold;
    }

    public static boolean checkThresholdsPositive(int bronze, int silver, int gold) {
        return 0 < bronze && 0 < silver && 0 < gold;
    }

    public static boolean checkImageType(String type) {
        return type.equals("image/svg") || type.equals("image/svg+xml") || type.equals("image/png") || type.equals("image/jpeg");
    }

    public Response validateBadge(@MultipartFormParam(value="name") FilePart name, @MultipartFormParam(value="description") FilePart description, @MultipartFormParam(value="enabled") FilePart enabled, @MultipartFormParam(value="thresholdBronze") FilePart thresholdBronze, @MultipartFormParam(value="thresholdSilver") FilePart thresholdSilver, @MultipartFormParam(value="thresholdGold") FilePart thresholdGold, @MultipartFormParam(value="bronzeImage") FilePart bronzeImage, @MultipartFormParam(value="silverImage") FilePart silverImage, @MultipartFormParam(value="goldImage") FilePart goldImage, @MultipartFormParam(value="neutralImage") FilePart neutralImage) {
        if (!BadgeRest.checkThresholdsPositive(Integer.parseInt(thresholdBronze.getValue()), Integer.parseInt(thresholdSilver.getValue()), Integer.parseInt(thresholdGold.getValue()))) {
            logger.error("Thresholds unacceptable. Bronze '{}', Silver '{}', Gold '{}'.", new Object[]{thresholdBronze.getValue(), thresholdSilver.getValue(), thresholdGold.getValue()});
            return Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)new Message("Thresholds must be greater than zero.")).build();
        }
        if (!BadgeRest.checkThresholdsOrder(Integer.parseInt(thresholdBronze.getValue()), Integer.parseInt(thresholdSilver.getValue()), Integer.parseInt(thresholdGold.getValue()))) {
            logger.error("Thresholds unacceptable. Bronze '{}', Silver '{}', Gold '{}'.", new Object[]{thresholdBronze.getValue(), thresholdSilver.getValue(), thresholdGold.getValue()});
            return Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)new Message(this.i18n.getText("badges.thresholds.unacceptable"))).build();
        }
        if (bronzeImage.getSize() > 0L && !BadgeRest.checkImageType(bronzeImage.getContentType())) {
            logger.error("BronzeImage unsupported. ContentType: '{}'.", (Object)bronzeImage.getContentType());
            return Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)new Message(this.i18n.getText("badges.bronze.image.unsupported"))).build();
        }
        if (silverImage.getSize() > 0L && !BadgeRest.checkImageType(silverImage.getContentType())) {
            logger.error("SilverImage unsupported. ContentType: '{}'.", (Object)silverImage.getContentType());
            return Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)new Message(this.i18n.getText("badges.silver.image.unsupported"))).build();
        }
        if (goldImage.getSize() > 0L && !BadgeRest.checkImageType(goldImage.getContentType())) {
            logger.error("GoldImage unsupported. ContentType: '{}'.", (Object)goldImage.getContentType());
            return Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)new Message(this.i18n.getText("badges.gold.image.unsupported"))).build();
        }
        if (neutralImage.getSize() > 0L && !BadgeRest.checkImageType(neutralImage.getContentType())) {
            logger.error("NeutralImage unsupported. ContentType: '{}'.", (Object)goldImage.getContentType());
            return Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)new Message(this.i18n.getText("badges.neutral.image.unsupported"))).build();
        }
        return Response.status((Response.Status)Response.Status.OK).entity((Object)new Message("ok")).build();
    }

    @PUT
    @Consumes(value={"multipart/form-data"})
    @Produces(value={"application/json"})
    @XsrfProtectionExcluded
    public Response createBadge(@MultipartFormParam(value="badge-id") FilePart id, @MultipartFormParam(value="name") FilePart name, @MultipartFormParam(value="description") FilePart description, @MultipartFormParam(value="enabled") FilePart enabled, @MultipartFormParam(value="thresholdBronze") FilePart thresholdBronze, @MultipartFormParam(value="thresholdSilver") FilePart thresholdSilver, @MultipartFormParam(value="thresholdGold") FilePart thresholdGold, @MultipartFormParam(value="bronzeImage") FilePart bronzeImage, @MultipartFormParam(value="silverImage") FilePart silverImage, @MultipartFormParam(value="goldImage") FilePart goldImage, @MultipartFormParam(value="neutralImage") FilePart neutralImage, @Context HttpServletRequest request) {
        if (!this.checkAdmin(request.getRemoteUser())) {
            logger.error("Unauthorized User request: '{}'.", (Object)request.getRemoteUser());
            return Response.status((Response.Status)Response.Status.UNAUTHORIZED).build();
        }
        String customId = "custom." + id.getValue();
        BadgeAO badgeAO = this.badgeService.get(customId);
        if (badgeAO != null) {
            logger.error("Badge id already exists.");
            return Response.status((Response.Status)Response.Status.CONFLICT).entity((Object)new Message(this.i18n.getText("badges.id.already.exists"))).build();
        }
        Response validationResult = this.validateBadge(name, description, enabled, thresholdBronze, thresholdSilver, thresholdGold, bronzeImage, silverImage, goldImage, neutralImage);
        if (validationResult.getStatus() != Response.Status.OK.getStatusCode()) {
            return validationResult;
        }
        Badge badge = new Badge();
        badge.setId(customId);
        badge.setThresholdBronze(Integer.valueOf(thresholdBronze.getValue()));
        badge.setThresholdSilver(Integer.valueOf(thresholdSilver.getValue()));
        badge.setThresholdGold(Integer.valueOf(thresholdGold.getValue()));
        String nameUtf = new String(name.getValue().getBytes(StandardCharsets.ISO_8859_1), StandardCharsets.UTF_8);
        String descUtf = new String(description.getValue().getBytes(StandardCharsets.ISO_8859_1), StandardCharsets.UTF_8);
        if (logger.isDebugEnabled()) {
            logger.debug("NameUtf: '{}'.", (Object)nameUtf);
            logger.debug("DescUtf: '{}'.", (Object)descUtf);
        }
        badge.setName(nameUtf);
        badge.setDescription(descUtf);
        badge.setEnabled(Boolean.valueOf(enabled.getValue()));
        if (bronzeImage.getSize() > 0L) {
            try {
                badge.setBronzeImage("/rest/badge/1.0/file/image/" + this.fileService.add(bronzeImage).getID());
            }
            catch (IOException e) {
                logger.error("IOException reading BronzeImage. Exception: '{}'.", (Throwable)e);
                return Response.status((Response.Status)Response.Status.INTERNAL_SERVER_ERROR).entity((Object)new Message(this.i18n.getText("badges.bronze.image.unreadable"))).build();
            }
        }
        if (silverImage.getSize() > 0L) {
            try {
                badge.setSilverImage("/rest/badge/1.0/file/image/" + this.fileService.add(silverImage).getID());
            }
            catch (IOException e) {
                logger.error("IOException reading SilverImage. Exception: '{}'.", (Throwable)e);
                return Response.status((Response.Status)Response.Status.INTERNAL_SERVER_ERROR).entity((Object)new Message(this.i18n.getText("badges.silver.image.unreadable"))).build();
            }
        }
        if (goldImage.getSize() > 0L) {
            try {
                badge.setGoldImage("/rest/badge/1.0/file/image/" + this.fileService.add(goldImage).getID());
            }
            catch (IOException e) {
                logger.error("IOException reading GoldImage. Exception: '{}'.", (Throwable)e);
                return Response.status((Response.Status)Response.Status.INTERNAL_SERVER_ERROR).entity((Object)new Message(this.i18n.getText("badges.gold.image.unreadable"))).build();
            }
        }
        if (neutralImage.getSize() > 0L) {
            try {
                badge.setNeutralImage("/rest/badge/1.0/file/image/" + this.fileService.add(neutralImage).getID());
            }
            catch (IOException e) {
                logger.error("IOException reading NeutralImage. Exception: '{}'.", (Throwable)e);
                return Response.status((Response.Status)Response.Status.INTERNAL_SERVER_ERROR).entity((Object)new Message(this.i18n.getText("badges.neutral.image.unreadable"))).build();
            }
        }
        BadgeAO result = this.badgeService.add(badge, this.getLocale(request.getRemoteUser()));
        return Response.ok((Object)result).build();
    }

    @PUT
    @Path(value="/{id}")
    @Consumes(value={"multipart/form-data"})
    @Produces(value={"application/json"})
    @XsrfProtectionExcluded
    public Response updateBadge(@PathParam(value="id") String id, @MultipartFormParam(value="name") FilePart name, @MultipartFormParam(value="description") FilePart description, @MultipartFormParam(value="enabled") FilePart enabled, @MultipartFormParam(value="thresholdBronze") FilePart thresholdBronze, @MultipartFormParam(value="thresholdSilver") FilePart thresholdSilver, @MultipartFormParam(value="thresholdGold") FilePart thresholdGold, @MultipartFormParam(value="bronzeImage") FilePart bronzeImage, @MultipartFormParam(value="silverImage") FilePart silverImage, @MultipartFormParam(value="goldImage") FilePart goldImage, @MultipartFormParam(value="neutralImage") FilePart neutralImage, @Context HttpServletRequest request) {
        if (!this.checkAdmin(request.getRemoteUser())) {
            logger.error("Unauthorized User request: '{}'.", (Object)request.getRemoteUser());
            return Response.status((Response.Status)Response.Status.UNAUTHORIZED).build();
        }
        BadgeAO badgeAO = this.badgeService.get(id);
        if (badgeAO == null) {
            logger.debug("BadgeAO is null.");
            return Response.status((Response.Status)Response.Status.NOT_FOUND).build();
        }
        Response validationResult = this.validateBadge(name, description, enabled, thresholdBronze, thresholdSilver, thresholdGold, bronzeImage, silverImage, goldImage, neutralImage);
        if (validationResult.getStatus() != Response.Status.OK.getStatusCode()) {
            return validationResult;
        }
        badgeAO.setEnabled(Boolean.parseBoolean(enabled.getValue()));
        badgeAO.setThresholdBronze(Integer.parseInt(thresholdBronze.getValue()));
        badgeAO.setThresholdSilver(Integer.parseInt(thresholdSilver.getValue()));
        badgeAO.setThresholdGold(Integer.parseInt(thresholdGold.getValue()));
        if (logger.isDebugEnabled()) {
            logger.debug("Enabled: '{}'.", (Object)enabled.getValue());
            logger.debug("ThresholdBronze: '{}'.", (Object)thresholdBronze.getValue());
            logger.debug("ThresholdSilver: '{}'.", (Object)thresholdSilver.getValue());
            logger.debug("ThresholdGold: '{}'.", (Object)thresholdGold.getValue());
        }
        if (bronzeImage.getSize() > 0L) {
            try {
                badgeAO.setBronzeImage("/rest/badge/1.0/file/image/" + this.fileService.add(bronzeImage).getID());
            }
            catch (IOException e) {
                logger.error("IOException reading BronzeImage.", (Throwable)e);
                return Response.status((Response.Status)Response.Status.INTERNAL_SERVER_ERROR).entity((Object)new Message(this.i18n.getText("badges.bronze.image.unreadable"))).build();
            }
        }
        if (silverImage.getSize() > 0L) {
            try {
                badgeAO.setSilverImage("/rest/badge/1.0/file/image/" + this.fileService.add(silverImage).getID());
            }
            catch (IOException e) {
                logger.error("IOException reading SilverImage.", (Throwable)e);
                return Response.status((Response.Status)Response.Status.INTERNAL_SERVER_ERROR).entity((Object)new Message(this.i18n.getText("badges.silver.image.unreadable"))).build();
            }
        }
        if (goldImage.getSize() > 0L) {
            try {
                badgeAO.setGoldImage("/rest/badge/1.0/file/image/" + this.fileService.add(goldImage).getID());
            }
            catch (IOException e) {
                logger.error("IOException reading GoldImage.", (Throwable)e);
                return Response.status((Response.Status)Response.Status.INTERNAL_SERVER_ERROR).entity((Object)new Message(this.i18n.getText("badges.gold.image.unreadable"))).build();
            }
        }
        if (neutralImage.getSize() > 0L) {
            try {
                badgeAO.setNeutralImage("/rest/badge/1.0/file/image/" + this.fileService.add(neutralImage).getID());
            }
            catch (IOException e) {
                logger.error("IOException reading NeutralImage.", (Throwable)e);
                return Response.status((Response.Status)Response.Status.INTERNAL_SERVER_ERROR).entity((Object)new Message(this.i18n.getText("badges.neutral.image.unreadable"))).build();
            }
        }
        String nameUtf = "";
        String descUtf = "";
        nameUtf = new String(name.getValue().getBytes(StandardCharsets.ISO_8859_1), StandardCharsets.UTF_8);
        descUtf = new String(description.getValue().getBytes(StandardCharsets.ISO_8859_1), StandardCharsets.UTF_8);
        if (logger.isDebugEnabled()) {
            logger.debug("NameUtf: '{}'.", (Object)nameUtf);
            logger.debug("DescUtf: '{}'.", (Object)descUtf);
        }
        this.badgeService.update(badgeAO, this.getLocale(request.getRemoteUser()), nameUtf, descUtf);
        String nameBadge = this.badgeService.getName(id, this.getLocale(request.getRemoteUser()));
        String descBadge = this.badgeService.getDesc(id, this.getLocale(request.getRemoteUser()));
        if (logger.isDebugEnabled()) {
            logger.debug("Name from DB: '{}'.", (Object)nameBadge);
            logger.debug("Desc from DB: '{}'.", (Object)descBadge);
        }
        return Response.ok((Object)new Badge(this.badgeService.get(id), nameBadge, descBadge)).build();
    }

    @GET
    @Path(value="/{id}")
    @Produces(value={"application/json"})
    public Response getBadge(@PathParam(value="id") String id, @Context HttpServletRequest request) {
        if (!this.checkAdmin(request.getRemoteUser())) {
            logger.error("Unauthorized User request: '{}'.", (Object)request.getRemoteUser());
            return Response.status((Response.Status)Response.Status.UNAUTHORIZED).build();
        }
        BadgeAO badgeAO = this.badgeService.get(id);
        if (badgeAO == null) {
            logger.error("BadgeAO is null.");
            return Response.status((Response.Status)Response.Status.NOT_FOUND).build();
        }
        if (logger.isDebugEnabled()) {
            logger.debug("BadgeAO: '{}'.", (Object)BadgeUtils.badgeAOToString(badgeAO));
        }
        String name = this.badgeService.getName(id, this.getLocale(request.getRemoteUser()));
        String desc = this.badgeService.getDesc(id, this.getLocale(request.getRemoteUser()));
        if (logger.isDebugEnabled()) {
            logger.debug("Name from DB: '{}'.", (Object)name);
            logger.debug("Desc from DB: '{}'.", (Object)desc);
        }
        return Response.ok((Object)new Badge(badgeAO, name, desc)).build();
    }

    @GET
    @Path(value="/default")
    @Produces(value={"application/json"})
    public Response getDefaultBadge(@PathParam(value="id") String id, @Context HttpServletRequest request) {
        String language;
        if (!this.checkAdmin(request.getRemoteUser())) {
            logger.error("Unauthorized User request: '{}'.", (Object)request.getRemoteUser());
            return Response.status((Response.Status)Response.Status.UNAUTHORIZED).build();
        }
        Badge result = new Badge();
        switch (language = this.getLocale(request.getRemoteUser()).getLanguage()) {
            case "de": {
                result.de();
                break;
            }
            default: {
                result.en();
            }
        }
        this.addContextPath(result);
        return Response.ok((Object)result).build();
    }

    private void addContextPath(Badge badge) {
        if (badge == null) {
            return;
        }
        String contextPath = this.settingsManager.getGlobalSettings().getBaseUrl();
        badge.setBronzeImage(contextPath + badge.getBronzeImage());
        badge.setSilverImage(contextPath + badge.getSilverImage());
        badge.setGoldImage(contextPath + badge.getGoldImage());
        badge.setNeutralImage(contextPath + badge.getNeutralImage());
    }

    @GET
    @Produces(value={"application/json"})
    public Response getAllBadges(@Context HttpServletRequest request) {
        if (!this.checkAdmin(request.getRemoteUser())) {
            logger.error("Unauthorized User request: '{}'.", (Object)request.getRemoteUser());
            return Response.status((Response.Status)Response.Status.UNAUTHORIZED).build();
        }
        List<BadgeAO> badgeAOs = this.badgeService.all();
        if (logger.isDebugEnabled()) {
            logger.debug("BadgeAos List size: '{}'.", (Object)badgeAOs.size());
        }
        ArrayList<Badge> badges = new ArrayList<Badge>();
        for (BadgeAO ao : badgeAOs) {
            String name = this.badgeService.getName(ao.getID(), this.getLocale(request.getRemoteUser()));
            String desc = this.badgeService.getDesc(ao.getID(), this.getLocale(request.getRemoteUser()));
            Badge badge = new Badge(ao, name, desc);
            badges.add(badge);
            if (!logger.isDebugEnabled()) continue;
            logger.debug("Badge added to Badges List: '{}'.", (Object)badge);
        }
        if (logger.isDebugEnabled()) {
            logger.debug("Badges List size: '{}'.", (Object)badges.size());
        }
        return Response.ok(badges).build();
    }

    private boolean checkAdmin(String userName) {
        return this.permissionManager.isConfluenceAdministrator((User)this.userAccessor.getUserByName(userName));
    }

    @GET
    @ReadOnlyAccessBlocked
    @Path(value="/enable")
    @Produces(value={"application/json"})
    public Response enableAllBadges(@Context HttpServletRequest request) {
        if (!this.checkAdmin(request.getRemoteUser())) {
            logger.error("Unauthorized User request: '{}'.", (Object)request.getRemoteUser());
            return Response.status((Response.Status)Response.Status.UNAUTHORIZED).build();
        }
        List<BadgeAO> badgeAOS = this.badgeService.all();
        for (BadgeAO badgeAO : badgeAOS) {
            badgeAO.setEnabled(true);
            this.badgeService.update(badgeAO);
        }
        return Response.ok((Object)new Message(this.i18n.getText("badges.enable.all.message"))).build();
    }

    @GET
    @ReadOnlyAccessBlocked
    @Path(value="/disable")
    @Produces(value={"application/json"})
    public Response disableAllBadges(@Context HttpServletRequest request) {
        if (!this.checkAdmin(request.getRemoteUser())) {
            logger.error("Unauthorized User request: '{}'.", (Object)request.getRemoteUser());
            return Response.status((Response.Status)Response.Status.UNAUTHORIZED).build();
        }
        List<BadgeAO> badgeAOS = this.badgeService.all();
        for (BadgeAO badgeAO : badgeAOS) {
            badgeAO.setEnabled(false);
            this.badgeService.update(badgeAO);
        }
        return Response.ok((Object)new Message(this.i18n.getText("badges.disable.all.message"))).build();
    }

    @DELETE
    @Path(value="/{id}")
    @Produces(value={"application/json"})
    public Response deleteBadge(@PathParam(value="id") String id, @Context HttpServletRequest request) {
        if (!this.checkAdmin(request.getRemoteUser())) {
            logger.error("Unauthorized User request: '{}'.", (Object)request.getRemoteUser());
            return Response.status((Response.Status)Response.Status.UNAUTHORIZED).build();
        }
        if (!id.contains("custom")) {
            return Response.status((Response.Status)Response.Status.FORBIDDEN).entity((Object)new Message("Built-in badges can not be deleted.")).build();
        }
        this.badgeService.delete(id);
        return Response.status((Response.Status)Response.Status.OK).entity((Object)new Message(String.format("Badge with id '%s' has been deleted.", id))).build();
    }

    private Locale getLocale(String username) {
        Locale result = this.localeManager.getLocale((User)this.userAccessor.getUserByName(username));
        if (logger.isDebugEnabled()) {
            logger.debug("Locale for user '{}': '{}'.", (Object)username, (Object)result);
        }
        return result;
    }
}

