/*
 * Decompiled with CFR 0.152.
 */
package com.agileants.confluence.plugin.badge.objects.dto;

import com.agileants.confluence.plugin.badge.utils.Convert;

public class RankingRow {
    private int page;
    private final String userKey;
    private final String userName;
    private final String userFullName;
    private final String userProfilePicture;
    private int rank;
    private int bronzeBadges;
    private int silverBadges;
    private int goldBadges;
    private int total;
    private int points;

    public RankingRow(String userKey, String userName, String userFullName, String userProfilePicture) {
        if (Convert.isEmpty(userKey)) {
            throw new IllegalArgumentException("userKey can't be null or empty string.");
        }
        if (Convert.isEmpty(userName)) {
            throw new IllegalArgumentException("userName can't be null or empty string.");
        }
        this.userKey = userKey;
        this.userName = userName;
        this.userFullName = Convert.isEmpty(userFullName) ? userName : userFullName;
        this.userProfilePicture = userProfilePicture;
        this.rank = 0;
        this.bronzeBadges = 0;
        this.silverBadges = 0;
        this.goldBadges = 0;
        this.total = 0;
        this.points = 0;
    }

    public RankingRow(String userKey) {
        this(userKey, userKey, null, null);
    }

    public int getPage() {
        return this.page;
    }

    public void setPage(int page) {
        this.page = page;
    }

    public String getKey() {
        return this.userKey;
    }

    public String getUsername() {
        return this.userName;
    }

    public String getUserFullName() {
        return this.userFullName;
    }

    public String getUserProfilePicture() {
        return this.userProfilePicture;
    }

    public int getRank() {
        return this.rank;
    }

    public void setRank(int rank) {
        this.rank = rank;
    }

    public int getBronzeBadges() {
        return this.bronzeBadges;
    }

    public void setBronzeBadges(int bronzeBadges) {
        this.bronzeBadges = bronzeBadges;
    }

    public void incrementBronzeBadges() {
        ++this.bronzeBadges;
    }

    public int getSilverBadges() {
        return this.silverBadges;
    }

    public void setSilverBadges(int silverBadges) {
        this.silverBadges = silverBadges;
    }

    public void incrementSilverBadges() {
        ++this.silverBadges;
    }

    public int getGoldBadges() {
        return this.goldBadges;
    }

    public void setGoldBadges(int goldBadges) {
        this.goldBadges = goldBadges;
    }

    public void incrementGoldBadges() {
        ++this.goldBadges;
    }

    public int getTotal() {
        return this.total;
    }

    public void setTotal(int total) {
        this.total = total;
    }

    public void calculateTotal() {
        this.total = this.bronzeBadges + this.silverBadges + this.goldBadges;
    }

    public int getPoints() {
        return this.points;
    }

    public void setPoints(int points) {
        this.points = points;
    }

    public String toString() {
        return "RankingRow{page=" + this.page + ", userKey='" + this.userKey + "', userName='" + this.userName + "', userFullName='" + this.userFullName + "', userProfilePicture='" + this.userProfilePicture + "', rank=" + this.rank + ", bronzeBadges=" + this.bronzeBadges + ", silverBadges=" + this.silverBadges + ", goldBadges=" + this.goldBadges + ", total=" + this.total + ", points=" + this.points + "}";
    }
}

