/*
 * Decompiled with CFR 0.152.
 */
package com.agileants.confluence.plugin.badge.objects.dto;

import com.agileants.confluence.plugin.badge.enums.Error;
import com.agileants.confluence.plugin.badge.objects.dto.User;
import java.util.ArrayList;
import java.util.List;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;

@XmlRootElement
public class ErrorMessage {
    private Error error;
    @XmlElement
    private String id;
    @XmlElement
    private String reason;
    @XmlElement
    private List<User> src = new ArrayList<User>();

    public ErrorMessage() {
    }

    public ErrorMessage(Error error, String reason) {
        this.error = error;
        this.id = error.getId();
        this.reason = reason;
    }

    public ErrorMessage(Error error) {
        this.error = error;
        this.id = error.getId();
    }

    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public String getReason() {
        return this.reason;
    }

    public void setReason(String reason) {
        this.reason = reason;
    }

    public ErrorMessage username(String username) {
        this.reason = String.format("User '%s' does not exist.", username);
        return this.error == Error.USER_NOT_FOUND ? this : null;
    }

    public ErrorMessage badgeId(String badgeId) {
        this.reason = String.format("Badge '%s' does not exist.", badgeId);
        return this.error == Error.BADGE_NOT_FOUND ? this : null;
    }

    public ErrorMessage count(int count) {
        this.reason = String.format("Count is '%d' but must be greater than 0.", count);
        return this.error == Error.COUNT_INVALID ? this : null;
    }

    public ErrorMessage time(String time) {
        this.reason = String.format("Time '%s' does not correspond to the required format 'yyyy-MM-ddTHH:mm:ss.SSSZ'.", time);
        return this.error == Error.TIME_INVALID ? this : null;
    }

    public ErrorMessage parameter(String name) {
        this.reason = String.format("Parameter '%s' is not supported.", name);
        return this.error == Error.PARAMETER_UNSUPPORTED ? this : null;
    }

    public ErrorMessage newCount(int newCount) {
        this.reason = String.format("New count of actions would become negative: '%d'.", newCount);
        return this.error == Error.NEW_COUNT_INVALID ? this : null;
    }

    public ErrorMessage reason(String value) {
        this.reason = value;
        return this;
    }

    public ErrorMessage src(List<User> value) {
        this.src = value;
        return value != null ? this : null;
    }

    public String toString() {
        return "ErrorMessage{error=" + this.error + ", id='" + this.id + "', reason='" + this.reason + "', src=" + this.src + "}";
    }
}

