/*
 * Decompiled with CFR 0.152.
 */
package com.agileants.confluence.plugin.badge.managers;

import com.agileants.confluence.plugin.badge.common.BaseListener;
import com.agileants.confluence.plugin.badge.managers.ListenerManager;
import com.agileants.confluence.plugin.badge.services.KeyValueService;
import com.agileants.confluence.plugin.badge.upgradetasks.InitTask;
import java.util.ArrayList;
import java.util.List;
import javax.inject.Inject;
import javax.inject.Named;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Named
public class ListenerManagerImpl
implements ListenerManager {
    private static final Logger logger = LoggerFactory.getLogger(InitTask.class);
    private final KeyValueService keyValueService;
    private final List<BaseListener> listeners;

    @Inject
    public ListenerManagerImpl(KeyValueService keyValueService) {
        this.keyValueService = keyValueService;
        this.listeners = new ArrayList<BaseListener>();
    }

    @Override
    public void register(BaseListener listener) {
        if (logger.isDebugEnabled()) {
            logger.debug("Listener '{}' registered.", (Object)listener.getId());
        }
        this.listeners.add(listener);
        if (this.keyValueService.isEnabled(listener.getId())) {
            if (logger.isDebugEnabled()) {
                logger.debug("enable listener.");
            }
            listener.enable();
        } else {
            if (logger.isDebugEnabled()) {
                logger.debug("disable listener.");
            }
            listener.disable();
        }
    }

    @Override
    public void unregister(BaseListener listener) {
        this.unregister(listener.getId());
    }

    @Override
    public void unregister(String id) {
        BaseListener listener;
        if (logger.isDebugEnabled()) {
            logger.debug("unregister listener '{}'.", (Object)id);
        }
        if ((listener = (BaseListener)this.listeners.stream().filter(x -> id.equals(x.getId())).findAny().orElse(null)) != null && listener.isEnabled()) {
            listener.disable();
            this.keyValueService.remove(String.format("%s.enabled", listener.getId()));
        }
    }

    @Override
    public void enableListener(String id) {
        BaseListener listener;
        if (logger.isDebugEnabled()) {
            logger.debug("enable listener '{}'.", (Object)id);
        }
        if ((listener = (BaseListener)this.listeners.stream().filter(x -> id.equals(x.getId())).findAny().orElse(null)) != null && !listener.isEnabled()) {
            listener.enable();
            this.keyValueService.enable(listener.getId());
        }
    }

    @Override
    public void disableListener(String id) {
        BaseListener listener;
        if (logger.isDebugEnabled()) {
            logger.debug("disable listener '{}'.", (Object)id);
        }
        if ((listener = (BaseListener)this.listeners.stream().filter(x -> id.equals(x.getId())).findAny().orElse(null)) != null && listener.isEnabled()) {
            listener.disable();
            this.keyValueService.disable(listener.getId());
        }
    }

    @Override
    public boolean isEnabled(String id) {
        boolean result;
        BaseListener listener;
        if (logger.isDebugEnabled()) {
            logger.debug("isEnable listener '{}'.", (Object)id);
        }
        if ((listener = (BaseListener)this.listeners.stream().filter(x -> id.equals(x.getId())).findAny().orElse(null)) != null) {
            if (logger.isDebugEnabled()) {
                logger.debug("found listener for id '{}'.", (Object)id);
            }
            result = listener.isEnabled();
        } else {
            if (logger.isDebugEnabled()) {
                logger.debug("can't find listener for id '{}'.", (Object)id);
            }
            result = false;
        }
        if (logger.isDebugEnabled()) {
            logger.debug("Listener '{}' enabled: '{}'.", (Object)id, (Object)result);
        }
        return result;
    }
}

