/*
 * Decompiled with CFR 0.152.
 */
package com.agileants.confluence.plugin.badge.managers;

import com.agileants.confluence.plugin.badge.managers.LicenseManager;
import com.atlassian.event.api.EventListener;
import com.atlassian.plugin.Plugin;
import com.atlassian.plugin.PluginAccessor;
import com.atlassian.plugin.spring.scanner.annotation.imports.ConfluenceImport;
import com.atlassian.upm.api.license.PluginLicenseEventRegistry;
import com.atlassian.upm.api.license.PluginLicenseManager;
import com.atlassian.upm.api.license.entity.PluginLicense;
import com.atlassian.upm.api.license.event.PluginLicenseChangeEvent;
import com.atlassian.upm.api.license.event.PluginLicenseRemovedEvent;
import javax.inject.Inject;
import javax.inject.Named;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.DisposableBean;
import org.springframework.beans.factory.InitializingBean;

@Named
public class LicenseManagerImpl
implements LicenseManager,
InitializingBean,
DisposableBean {
    private static final Logger logger = LoggerFactory.getLogger(LicenseManagerImpl.class);
    private static final String PLUGIN_ID = "com.agileants.confluence.plugin.badge";
    @ConfluenceImport
    private final PluginAccessor pluginAccessor;
    @ConfluenceImport
    private final PluginLicenseEventRegistry pluginLicenseEventRegistry;
    @ConfluenceImport
    private final PluginLicenseManager pluginLicenseManager;
    private boolean licenseValid = false;
    private boolean licensed = true;

    @Inject
    public LicenseManagerImpl(PluginAccessor pluginAccessor, PluginLicenseEventRegistry pluginLicenseEventRegistry, PluginLicenseManager pluginLicenseManager) {
        this.pluginAccessor = pluginAccessor;
        this.pluginLicenseEventRegistry = pluginLicenseEventRegistry;
        this.pluginLicenseManager = pluginLicenseManager;
    }

    public void afterPropertiesSet() throws Exception {
        Plugin plugin = this.pluginAccessor.getPlugin(PLUGIN_ID);
        if (plugin == null) {
            throw new Exception(String.format("can't find plugin for id: '%s'.", PLUGIN_ID));
        }
        String tmp = (String)plugin.getPluginInformation().getParameters().get("atlassian-licensing-enabled");
        boolean bl = this.licensed = tmp == null ? false : Boolean.parseBoolean(tmp);
        if (logger.isDebugEnabled()) {
            logger.debug(String.format("Licensed use: '%s'.", Boolean.toString(this.licensed)));
        }
        if (this.licensed) {
            this.pluginLicenseEventRegistry.register((Object)this);
            this.checkLicense();
        }
    }

    @Override
    @EventListener
    public void onLicenseChanged(PluginLicenseChangeEvent event) {
        if (logger.isDebugEnabled()) {
            logger.debug("License changed.");
        }
        this.checkLicense();
    }

    @Override
    @EventListener
    public void onLicenseRemoved(PluginLicenseRemovedEvent event) {
        if (logger.isDebugEnabled()) {
            logger.debug("License removed.");
        }
        this.checkLicense();
    }

    @Override
    public boolean checkLicense() {
        if (logger.isDebugEnabled()) {
            logger.debug(String.format("Licensed use: '%s'.", this.licensed));
        }
        if (!this.licensed) {
            return true;
        }
        if (this.pluginLicenseManager.getLicense().isDefined()) {
            PluginLicense license = (PluginLicense)this.pluginLicenseManager.getLicense().get();
            if (license.getError().isDefined()) {
                if (logger.isDebugEnabled()) {
                    logger.debug("License error. License may be expired or not present.");
                }
                this.licenseValid = false;
            } else {
                if (logger.isInfoEnabled()) {
                    logger.info("Valid license.");
                }
                this.licenseValid = true;
            }
        } else {
            if (logger.isInfoEnabled()) {
                logger.info("Unlicensed.");
            }
            this.licenseValid = false;
        }
        return this.licenseValid;
    }

    public void destroy() throws Exception {
        this.pluginLicenseEventRegistry.unregister((Object)this);
        if (logger.isDebugEnabled()) {
            logger.debug("LicenseManagerImpl destroyed.");
        }
    }
}

