/*
 * Decompiled with CFR 0.152.
 */
package com.agileants.confluence.plugin.badge.listener.questions;

import com.agileants.confluence.plugin.badge.common.BaseListenerQuestions;
import com.agileants.confluence.plugin.badge.managers.ListenerManager;
import com.agileants.confluence.plugin.badge.services.BadgeService;
import com.agileants.confluence.plugin.badge.services.NotificationService;
import com.agileants.confluence.plugin.badge.services.UserService;
import com.atlassian.activeobjects.external.ActiveObjects;
import com.atlassian.confluence.api.service.accessmode.AccessModeService;
import com.atlassian.confluence.core.ContentEntityManager;
import com.atlassian.confluence.user.UserAccessor;
import com.atlassian.event.api.EventListener;
import com.atlassian.event.api.EventPublisher;
import com.atlassian.plugin.spring.scanner.annotation.imports.ConfluenceImport;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import javax.inject.Inject;
import javax.inject.Named;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Named
public class QuestionGetVotedListener
extends BaseListenerQuestions {
    public static final String ID = "question.get.voted";
    private static final Logger logger = LoggerFactory.getLogger(QuestionGetVotedListener.class);
    private static final String EVENT_NAME = "com.atlassian.confluence.plugins.questions.event.QuestionVoteCreatedEvent";
    private static final String VOTE_TYPE = "up";

    @Inject
    public QuestionGetVotedListener(@ConfluenceImport EventPublisher eventPublisher, @ConfluenceImport UserAccessor userAccessor, UserService userService, @ConfluenceImport ActiveObjects activeObjects, BadgeService badgeService, NotificationService notificationService, @ConfluenceImport ContentEntityManager contentEntityManager, ListenerManager listenerManager, @ConfluenceImport AccessModeService accessModeService) {
        super(ID, eventPublisher, userAccessor, userService, activeObjects, badgeService, notificationService, contentEntityManager, listenerManager, accessModeService);
    }

    @EventListener
    public void onQuestionGetVotedEvent(Object event) {
        String eventName = event.getClass().getCanonicalName();
        if (EVENT_NAME.equals(eventName)) {
            if (logger.isDebugEnabled()) {
                logger.debug("On question created event listened.");
            }
            try {
                Method getVoteType = event.getClass().getMethod("getVoteType", new Class[0]);
                Object voteType = getVoteType.invoke(event, new Object[0]);
                Method getKey = voteType.getClass().getMethod("getKey", new Class[0]);
                String voteTypeStr = (String)getKey.invoke(voteType, new Object[0]);
                if (VOTE_TYPE.equals(voteTypeStr)) {
                    Method getQuestionId = event.getClass().getMethod("getQuestionId", new Class[0]);
                    long questionId = (Long)getQuestionId.invoke(event, new Object[0]);
                    String creator = this.getContentCreator(questionId);
                    if (logger.isDebugEnabled()) {
                        logger.debug("Event '{}' listened. Receives Vote: '{}'.", (Object)ID, (Object)creator);
                    }
                    this.incrementCount(creator, ID);
                    this.checkLevelUp(creator, ID);
                }
            }
            catch (IllegalAccessException | NoSuchMethodException | InvocationTargetException e) {
                logger.error(String.format("processing '%s' failed.", eventName), (Throwable)e);
            }
        }
    }
}

