/*
 * Decompiled with CFR 0.152.
 */
package com.agileants.confluence.plugin.badge.listener.questions;

import com.agileants.confluence.plugin.badge.common.BaseListenerQuestions;
import com.agileants.confluence.plugin.badge.managers.ListenerManager;
import com.agileants.confluence.plugin.badge.services.BadgeService;
import com.agileants.confluence.plugin.badge.services.NotificationService;
import com.agileants.confluence.plugin.badge.services.UserService;
import com.atlassian.activeobjects.external.ActiveObjects;
import com.atlassian.confluence.api.service.accessmode.AccessModeService;
import com.atlassian.confluence.core.ContentEntityManager;
import com.atlassian.confluence.user.UserAccessor;
import com.atlassian.event.api.EventListener;
import com.atlassian.event.api.EventPublisher;
import com.atlassian.plugin.spring.scanner.annotation.imports.ConfluenceImport;
import com.atlassian.sal.api.user.UserKey;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import javax.inject.Inject;
import javax.inject.Named;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Named
public class AnswerCreatedListener
extends BaseListenerQuestions {
    public static final String ID = "answer.created";
    private static final Logger logger = LoggerFactory.getLogger(AnswerCreatedListener.class);
    private static final String EVENT_NAME = "com.atlassian.confluence.plugins.questions.event.AnswerCreatedEvent";

    @Inject
    public AnswerCreatedListener(@ConfluenceImport EventPublisher eventPublisher, @ConfluenceImport UserAccessor userAccessor, UserService userService, @ConfluenceImport ActiveObjects activeObjects, BadgeService badgeService, NotificationService notificationService, @ConfluenceImport ContentEntityManager contentEntityManager, ListenerManager listenerManager, @ConfluenceImport AccessModeService accessModeService) {
        super(ID, eventPublisher, userAccessor, userService, activeObjects, badgeService, notificationService, contentEntityManager, listenerManager, accessModeService);
    }

    @EventListener
    public void onAnswerCreatedEvent(Object event) {
        String eventName = event.getClass().getCanonicalName();
        if (EVENT_NAME.equals(eventName)) {
            if (logger.isDebugEnabled()) {
                logger.debug("On answer created event listened.");
            }
            try {
                Method m = event.getClass().getMethod("getOriginatingUserKey", new Class[0]);
                UserKey userKey = (UserKey)m.invoke(event, new Object[0]);
                if (logger.isDebugEnabled()) {
                    logger.debug("Event '{}' listened. Creator: '{}'.", (Object)ID, (Object)userKey);
                }
                this.incrementCount(userKey.getStringValue(), ID);
                this.checkLevelUp(userKey.getStringValue(), ID);
            }
            catch (IllegalAccessException | NoSuchMethodException | InvocationTargetException e) {
                logger.error(String.format("processing '%s' failed.", eventName), (Throwable)e);
            }
        }
    }
}

