/*
 * Decompiled with CFR 0.152.
 */
package com.agileants.confluence.plugin.badge.listener.confluence;

import com.agileants.confluence.plugin.badge.common.BaseListener;
import com.agileants.confluence.plugin.badge.listener.confluence.PageCreateListener;
import com.agileants.confluence.plugin.badge.managers.ListenerManager;
import com.agileants.confluence.plugin.badge.services.BadgeService;
import com.agileants.confluence.plugin.badge.services.NotificationService;
import com.agileants.confluence.plugin.badge.services.UserService;
import com.atlassian.confluence.api.service.accessmode.AccessModeService;
import com.atlassian.confluence.event.events.space.SpaceCreateEvent;
import com.atlassian.confluence.user.UserAccessor;
import com.atlassian.event.api.EventListener;
import com.atlassian.event.api.EventPublisher;
import com.atlassian.plugin.spring.scanner.annotation.imports.ConfluenceImport;
import javax.inject.Inject;
import javax.inject.Named;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Named
public class SpaceCreateListener
extends BaseListener {
    public static final String ID = "space.created";
    private static final Logger logger = LoggerFactory.getLogger(PageCreateListener.class);

    @Inject
    public SpaceCreateListener(@ConfluenceImport EventPublisher eventPublisher, @ConfluenceImport UserAccessor userAccessor, UserService userService, BadgeService badgeService, NotificationService notificationService, ListenerManager listenerManager, AccessModeService accessModeService) {
        super(ID, eventPublisher, userAccessor, userService, badgeService, notificationService, listenerManager, accessModeService);
    }

    @EventListener
    public void onSpaceCreateEvent(SpaceCreateEvent event) {
        if (logger.isDebugEnabled()) {
            logger.debug("Space create event listened.");
        }
        String userKey = event.getSpace().getCreator().getKey().getStringValue();
        this.incrementCountByKey(userKey, ID);
        this.checkLevelUpByKey(userKey, ID);
        if (logger.isDebugEnabled()) {
            logger.debug("Event '{}' listened. Creator: '{}'.", (Object)ID, (Object)event.getSpace().getCreator());
        }
    }
}

