/*
 * Decompiled with CFR 0.152.
 */
package com.agileants.confluence.plugin.badge.listener.confluence;

import com.agileants.confluence.plugin.badge.common.BaseListener;
import com.agileants.confluence.plugin.badge.listener.confluence.PageCreateListener;
import com.agileants.confluence.plugin.badge.managers.ListenerManager;
import com.agileants.confluence.plugin.badge.services.BadgeService;
import com.agileants.confluence.plugin.badge.services.NotificationService;
import com.agileants.confluence.plugin.badge.services.UserService;
import com.atlassian.confluence.api.service.accessmode.AccessModeService;
import com.atlassian.confluence.event.events.content.page.PageUpdateEvent;
import com.atlassian.confluence.user.UserAccessor;
import com.atlassian.event.api.EventListener;
import com.atlassian.event.api.EventPublisher;
import com.atlassian.plugin.spring.scanner.annotation.imports.ConfluenceImport;
import javax.inject.Inject;
import javax.inject.Named;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Named
public class PageUpdateListener
extends BaseListener {
    public static final String ID = "page.updated";
    private static final Logger logger = LoggerFactory.getLogger(PageCreateListener.class);

    @Inject
    public PageUpdateListener(@ConfluenceImport EventPublisher eventPublisher, @ConfluenceImport UserAccessor userAccessor, UserService userService, BadgeService badgeService, NotificationService notificationService, ListenerManager listenerManager, AccessModeService accessModeService) {
        super(ID, eventPublisher, userAccessor, userService, badgeService, notificationService, listenerManager, accessModeService);
    }

    @EventListener
    public void onPageUpdateEvent(PageUpdateEvent event) {
        String creator;
        String modifier;
        if (logger.isDebugEnabled()) {
            logger.debug("Page update event listened.");
        }
        if (!(modifier = event.getNew().getLastModifier().getKey().getStringValue()).equals(creator = event.getContent().getCreator().getKey().getStringValue())) {
            if (logger.isDebugEnabled()) {
                logger.debug("Event '{}' listened. Modifier: '{}'. Creator: '{}'.", new Object[]{ID, event.getNew().getLastModifier(), event.getContent().getCreator()});
            }
            this.incrementCountByKey(modifier, ID);
            this.checkLevelUpByKey(modifier, ID);
        }
    }
}

