/*
 * Decompiled with CFR 0.152.
 */
package com.agileants.confluence.plugin.badge.listener.confluence;

import com.agileants.confluence.plugin.badge.common.BaseListener;
import com.agileants.confluence.plugin.badge.listener.confluence.PageCreateListener;
import com.agileants.confluence.plugin.badge.managers.ListenerManager;
import com.agileants.confluence.plugin.badge.services.BadgeService;
import com.agileants.confluence.plugin.badge.services.NotificationService;
import com.agileants.confluence.plugin.badge.services.UserService;
import com.atlassian.confluence.api.service.accessmode.AccessModeService;
import com.atlassian.confluence.event.events.content.page.PageTrashedEvent;
import com.atlassian.confluence.user.ConfluenceUser;
import com.atlassian.confluence.user.UserAccessor;
import com.atlassian.event.api.EventListener;
import com.atlassian.event.api.EventPublisher;
import com.atlassian.plugin.spring.scanner.annotation.imports.ConfluenceImport;
import com.atlassian.user.User;
import javax.inject.Inject;
import javax.inject.Named;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Named
public class PageTrashedListener
extends BaseListener {
    public static final String ID = "page.trashed";
    private static final Logger logger = LoggerFactory.getLogger(PageCreateListener.class);

    @Inject
    public PageTrashedListener(@ConfluenceImport EventPublisher eventPublisher, @ConfluenceImport UserAccessor userAccessor, UserService userService, BadgeService badgeService, NotificationService notificationService, ListenerManager listenerManager, AccessModeService accessModeService) {
        super(ID, eventPublisher, userAccessor, userService, badgeService, notificationService, listenerManager, accessModeService);
    }

    @EventListener
    public void onPageTrashedEvent(PageTrashedEvent event) {
        ConfluenceUser creator;
        User originatingUser;
        if (logger.isDebugEnabled()) {
            logger.debug("Page trashed event listened.");
        }
        if (this.checkSameUser(originatingUser = event.getOriginatingUser(), creator = event.getContent().getCreator())) {
            if (logger.isDebugEnabled()) {
                logger.debug("Event '{}' listened. OriginatingUser: '{}'. Creator: '{}'.", new Object[]{ID, event.getOriginatingUser(), event.getContent().getCreator()});
            }
            String userKey = event.getContent().getCreator().getKey().getStringValue();
            this.incrementCountByKey(userKey, ID);
            this.checkLevelUpByKey(userKey, ID);
        }
    }
}

