/*
 * Decompiled with CFR 0.152.
 */
package com.agileants.confluence.plugin.badge.listener.confluence;

import com.agileants.confluence.plugin.badge.common.BaseListener;
import com.agileants.confluence.plugin.badge.managers.ListenerManager;
import com.agileants.confluence.plugin.badge.services.BadgeService;
import com.agileants.confluence.plugin.badge.services.NotificationService;
import com.agileants.confluence.plugin.badge.services.UserService;
import com.atlassian.confluence.api.service.accessmode.AccessModeService;
import com.atlassian.confluence.event.events.content.page.PageCreateEvent;
import com.atlassian.confluence.user.UserAccessor;
import com.atlassian.event.api.EventListener;
import com.atlassian.event.api.EventPublisher;
import com.atlassian.plugin.spring.scanner.annotation.imports.ConfluenceImport;
import javax.inject.Inject;
import javax.inject.Named;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Named
public class PageCreateListener
extends BaseListener {
    public static final String ID = "page.created";
    private static final Logger logger = LoggerFactory.getLogger(PageCreateListener.class);

    @Inject
    public PageCreateListener(@ConfluenceImport EventPublisher eventPublisher, @ConfluenceImport UserAccessor userAccessor, UserService userService, BadgeService badgeService, NotificationService notificationService, ListenerManager listenerManager, AccessModeService accessModeService) {
        super(ID, eventPublisher, userAccessor, userService, badgeService, notificationService, listenerManager, accessModeService);
    }

    @EventListener
    public void onPageCreateEvent(PageCreateEvent event) {
        if (logger.isDebugEnabled()) {
            logger.debug("Page create event listened.");
        }
        String userKey = event.getContent().getCreator().getKey().getStringValue();
        this.incrementCountByKey(userKey, ID);
        this.checkLevelUpByKey(userKey, ID);
        if (logger.isDebugEnabled()) {
            logger.debug("Event '{}' listened. Creator: '{}'.", (Object)ID, (Object)event.getContent().getCreator());
        }
    }
}

