/*
 * Decompiled with CFR 0.152.
 */
package com.agileants.confluence.plugin.badge.listener.confluence;

import com.agileants.confluence.plugin.badge.activeobjects.EventAO;
import com.agileants.confluence.plugin.badge.services.EventService;
import com.agileants.confluence.plugin.badge.services.KeyValueService;
import com.atlassian.activeobjects.external.ActiveObjects;
import com.atlassian.confluence.api.service.accessmode.AccessModeService;
import com.atlassian.confluence.event.events.ConfluenceEvent;
import com.atlassian.event.api.EventListener;
import com.atlassian.event.api.EventPublisher;
import com.atlassian.plugin.spring.scanner.annotation.imports.ConfluenceImport;
import javax.inject.Inject;
import javax.inject.Named;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.DisposableBean;
import org.springframework.beans.factory.InitializingBean;

@Named
public class ConfluenceEventListener
implements InitializingBean,
DisposableBean {
    public static final String ID = "confluence.event";
    private static final Logger logger = LoggerFactory.getLogger(ConfluenceEventListener.class);
    private final EventService eventService;
    private final KeyValueService keyValueService;
    @ConfluenceImport
    private final EventPublisher eventPublisher;
    @ConfluenceImport
    private final ActiveObjects ao;
    @ConfluenceImport
    private final AccessModeService accessModeService;
    private boolean enabled;

    @Inject
    public ConfluenceEventListener(EventService eventService, KeyValueService keyValueService, EventPublisher eventPublisher, ActiveObjects ao, AccessModeService accessModeService) {
        if (eventService == null) {
            throw new IllegalArgumentException("eventService can't be null.");
        }
        if (keyValueService == null) {
            throw new IllegalArgumentException("keyValueService can't be null.");
        }
        if (eventPublisher == null) {
            throw new IllegalArgumentException("eventPublisher can't be null.");
        }
        if (ao == null) {
            throw new IllegalArgumentException("ao can't be null.");
        }
        if (accessModeService == null) {
            throw new IllegalArgumentException("accessModeService can't be null.");
        }
        this.eventService = eventService;
        this.keyValueService = keyValueService;
        this.eventPublisher = eventPublisher;
        this.ao = ao;
        this.accessModeService = accessModeService;
    }

    public void afterPropertiesSet() throws Exception {
        if (logger.isDebugEnabled()) {
            logger.debug("Listener '{}' registering at EventPublisher...", (Object)ID);
        }
        this.eventPublisher.register((Object)this);
        if (this.keyValueService.isEnabled(ID)) {
            this.enable();
        } else {
            this.disable();
        }
    }

    public void enable() {
        if (logger.isDebugEnabled()) {
            logger.debug("Listener '{}' enabled.", (Object)ID);
        }
        this.eventPublisher.register((Object)this);
        this.keyValueService.enable(ID);
        this.enabled = true;
    }

    public void disable() {
        if (logger.isDebugEnabled()) {
            logger.debug("Listener '{}' disabled.", (Object)ID);
        }
        this.eventPublisher.unregister((Object)this);
        this.keyValueService.disable(ID);
        this.enabled = false;
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    @EventListener
    public void onConfluenceEvent(ConfluenceEvent event) {
        if (logger.isDebugEnabled()) {
            logger.debug("Event '{}' listened.", (Object)event.getClass().getCanonicalName());
        }
        if (this.accessModeService.isReadOnlyAccessModeEnabled()) {
            if (logger.isDebugEnabled()) {
                logger.debug("Read-only mode enabled. Action 'onConfluenceEvent' will not be performed.");
            }
            return;
        }
        try {
            EventAO eventAO = this.eventService.add(event.getClass().getCanonicalName(), event.getTimestamp());
            if (logger.isDebugEnabled()) {
                logger.debug(String.format("EVENT WRITTEN. ID: %d.", eventAO.getID()));
            }
        }
        catch (IllegalStateException illegalStateException) {
            // empty catch block
        }
    }

    public void destroy() throws Exception {
        this.eventPublisher.unregister((Object)this);
    }
}

