/*
 * Decompiled with CFR 0.152.
 */
package com.agileants.confluence.plugin.badge.listener.confluence;

import com.agileants.confluence.plugin.badge.common.BaseListener;
import com.agileants.confluence.plugin.badge.managers.ListenerManager;
import com.agileants.confluence.plugin.badge.services.BadgeService;
import com.agileants.confluence.plugin.badge.services.NotificationService;
import com.agileants.confluence.plugin.badge.services.UserService;
import com.atlassian.confluence.api.service.accessmode.AccessModeService;
import com.atlassian.confluence.core.ContentEntityObject;
import com.atlassian.confluence.event.events.content.comment.CommentCreateEvent;
import com.atlassian.confluence.user.ConfluenceUser;
import com.atlassian.confluence.user.UserAccessor;
import com.atlassian.event.api.EventListener;
import com.atlassian.event.api.EventPublisher;
import com.atlassian.plugin.spring.scanner.annotation.imports.ConfluenceImport;
import javax.inject.Inject;
import javax.inject.Named;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Named
public class CommentCreateListener
extends BaseListener {
    public static final String ID = "comment.created";
    private static final Logger logger = LoggerFactory.getLogger(CommentCreateListener.class);

    @Inject
    public CommentCreateListener(@ConfluenceImport EventPublisher eventPublisher, @ConfluenceImport UserAccessor userAccessor, UserService userService, BadgeService badgeService, NotificationService notificationService, ListenerManager listenerManager, AccessModeService accessModeService) {
        super(ID, eventPublisher, userAccessor, userService, badgeService, notificationService, listenerManager, accessModeService);
    }

    @EventListener
    public void onCommentCreateEvent(CommentCreateEvent event) {
        ContentEntityObject content;
        if (logger.isDebugEnabled()) {
            logger.debug("Comment create event listened.");
        }
        if ((content = event.getContent()) == null) {
            logger.warn("event without content: {}.", (Object)event);
            return;
        }
        ConfluenceUser creator = content.getCreator();
        if (creator == null) {
            logger.warn("content without creator: {}.", (Object)creator);
            return;
        }
        if (logger.isDebugEnabled()) {
            logger.debug("Event '{}' listened. Creator: '{}'.", (Object)ID, (Object)creator);
        }
        String userKey = creator.getKey().getStringValue();
        this.incrementCountByKey(userKey, ID);
        this.checkLevelUpByKey(userKey, ID);
    }
}

