/*
 * Decompiled with CFR 0.152.
 */
package com.agileants.confluence.plugin.badge.jobs;

import com.agileants.confluence.plugin.badge.objects.dto.RankingRow;
import com.agileants.confluence.plugin.badge.services.BadgeService;
import com.agileants.confluence.plugin.badge.services.IConfluenceUserSource;
import com.agileants.confluence.plugin.badge.services.KeyValueService;
import com.agileants.confluence.plugin.badge.services.RankingService;
import com.agileants.confluence.plugin.badge.services.UserService;
import com.agileants.confluence.plugin.badge.services.impl.ConfluenceUserSource;
import com.atlassian.activeobjects.external.ActiveObjects;
import com.atlassian.confluence.api.service.accessmode.AccessModeService;
import com.atlassian.confluence.setup.settings.SettingsManager;
import com.atlassian.confluence.user.UserAccessor;
import com.atlassian.plugin.spring.scanner.annotation.imports.ConfluenceImport;
import com.atlassian.scheduler.JobRunner;
import com.atlassian.scheduler.JobRunnerRequest;
import com.atlassian.scheduler.JobRunnerResponse;
import java.util.List;
import java.util.Map;
import javax.annotation.Nullable;
import javax.inject.Inject;
import javax.inject.Named;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Named
public class RankingTableRunner
implements JobRunner {
    private static final Logger logger = LoggerFactory.getLogger(RankingTableRunner.class);
    public static final String RANKING_TABLE_LAST_UPDATED = "ranking.table.last.updated";
    public static final String RANKING_TABLE_LAST_PAGE = "ranking.table.last.page";
    public static final int PAGING = 20;
    private final RankingService rankingService;
    private final BadgeService badgeService;
    private final UserService userService;
    private final IConfluenceUserSource confluenceUserSource;
    private final KeyValueService keyValueService;
    @ConfluenceImport
    private final ActiveObjects ao;
    @ConfluenceImport
    private final UserAccessor userAccessor;
    @ConfluenceImport
    private final SettingsManager settingsManager;
    @ConfluenceImport
    private final AccessModeService accessModeService;

    @Inject
    public RankingTableRunner(RankingService rankingService, BadgeService badgeService, UserService userService, KeyValueService keyValueService, ActiveObjects ao, UserAccessor userAccessor, SettingsManager settingsManager, AccessModeService accessModeService) {
        if (rankingService == null || badgeService == null) {
            throw new IllegalArgumentException("badgeService can't be null.");
        }
        if (userService == null) {
            throw new IllegalArgumentException("userService can't be null.");
        }
        if (keyValueService == null) {
            throw new IllegalArgumentException("keyValueService can't be null.");
        }
        if (ao == null) {
            throw new IllegalArgumentException("ao can't be null.");
        }
        if (userAccessor == null) {
            throw new IllegalArgumentException("userAccessor can't be null.");
        }
        if (settingsManager == null) {
            throw new IllegalArgumentException("settingsManager can't be null.");
        }
        if (accessModeService == null) {
            throw new IllegalArgumentException("accessModeService can't be null.");
        }
        this.rankingService = rankingService;
        this.badgeService = badgeService;
        this.userService = userService;
        this.keyValueService = keyValueService;
        this.ao = ao;
        this.userAccessor = userAccessor;
        this.settingsManager = settingsManager;
        this.accessModeService = accessModeService;
        this.confluenceUserSource = ConfluenceUserSource.get(this.userAccessor, this.settingsManager, userService);
    }

    @Nullable
    public JobRunnerResponse runJob(JobRunnerRequest request) {
        if (logger.isDebugEnabled()) {
            logger.debug("Ranking table update: start..");
        }
        if (request.isCancellationRequested()) {
            return JobRunnerResponse.aborted((String)"Job cancelled.");
        }
        if (this.accessModeService.isReadOnlyAccessModeEnabled()) {
            return JobRunnerResponse.aborted((String)"Job cancelled because of active read-only mode.");
        }
        try {
            Map[] allUsers = new Map[]{null};
            List[] users = new List[]{null};
            Map[] badges = new Map[]{null};
            this.ao.executeInTransaction(() -> {
                allUsers[0] = this.confluenceUserSource.getAll();
                users[0] = this.userService.all();
                badges[0] = this.badgeService.allAsMap();
                return null;
            });
            if (allUsers[0] == null) {
                throw new NullPointerException("allUsers can't be null.");
            }
            if (users[0] == null) {
                throw new NullPointerException("userAOs can't be null.");
            }
            if (badges[0] == null) {
                throw new NullPointerException("badgeAOs can't be null.");
            }
            List<RankingRow> rankingTable = this.rankingService.calculateRanking(allUsers[0], users[0], badges[0], 20);
            if (rankingTable == null) {
                throw new NullPointerException("rankingTable can't be null.");
            }
            this.ao.executeInTransaction(() -> {
                this.rankingService.saveRanking(rankingTable);
                return null;
            });
            this.keyValueService.put(RANKING_TABLE_LAST_UPDATED, String.valueOf(System.currentTimeMillis()));
            int lastPage = rankingTable.size() > 0 ? rankingTable.get(rankingTable.size() - 1).getPage() : 0;
            this.keyValueService.put(RANKING_TABLE_LAST_PAGE, String.valueOf(lastPage));
        }
        catch (Throwable th) {
            logger.error("error", th);
            return JobRunnerResponse.failed((Throwable)th);
        }
        if (logger.isDebugEnabled()) {
            logger.debug("Ranking table update: DONE.");
        }
        return JobRunnerResponse.success();
    }
}

