/*
 * Decompiled with CFR 0.152.
 */
package com.agileants.confluence.plugin.badge.common;

import com.agileants.confluence.plugin.badge.common.BaseListener;
import com.agileants.confluence.plugin.badge.managers.ListenerManager;
import com.agileants.confluence.plugin.badge.services.BadgeService;
import com.agileants.confluence.plugin.badge.services.NotificationService;
import com.agileants.confluence.plugin.badge.services.UserService;
import com.atlassian.activeobjects.external.ActiveObjects;
import com.atlassian.confluence.api.service.accessmode.AccessModeService;
import com.atlassian.confluence.core.ContentEntityManager;
import com.atlassian.confluence.user.UserAccessor;
import com.atlassian.event.api.EventPublisher;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BaseListenerQuestions
extends BaseListener {
    private static final Logger logger = LoggerFactory.getLogger(BaseListenerQuestions.class);
    private final ActiveObjects activeObjects;
    private final ContentEntityManager contentEntityManager;

    protected BaseListenerQuestions(String id, EventPublisher eventPublisher, UserAccessor userAccessor, UserService userService, ActiveObjects activeObjects, BadgeService badgeService, NotificationService notificationService, ContentEntityManager contentEntityManager, ListenerManager listenerManager, AccessModeService accessModeService) {
        super(id, eventPublisher, userAccessor, userService, badgeService, notificationService, listenerManager, accessModeService);
        this.activeObjects = activeObjects;
        this.contentEntityManager = contentEntityManager;
    }

    protected final ActiveObjects getActiveObjects() {
        return this.activeObjects;
    }

    protected void incrementCount(String userKey, String badgeID) {
        this.getActiveObjects().executeInTransaction(() -> {
            super.incrementCountByKey(userKey, badgeID);
            return null;
        });
    }

    protected void checkLevelUp(String userKey, String badgeID) {
        this.getActiveObjects().executeInTransaction(() -> {
            super.checkLevelUpByKey(userKey, badgeID);
            return null;
        });
    }

    protected String getContentCreator(long id) {
        String result = this.contentEntityManager.getById(id).getCreator().getKey().getStringValue();
        if (logger.isDebugEnabled()) {
            logger.debug("ContentCreatorUserKey for contentId '{}': '{}'.", (Object)id, (Object)result);
        }
        return result;
    }
}

