/*
 * Decompiled with CFR 0.152.
 */
package com.agileants.confluence.plugin.badge.common;

import com.agileants.confluence.plugin.badge.activeobjects.BadgeAO;
import com.agileants.confluence.plugin.badge.enums.Level;
import com.agileants.confluence.plugin.badge.managers.ListenerManager;
import com.agileants.confluence.plugin.badge.services.BadgeService;
import com.agileants.confluence.plugin.badge.services.NotificationService;
import com.agileants.confluence.plugin.badge.services.UserService;
import com.atlassian.confluence.api.service.accessmode.AccessModeService;
import com.atlassian.confluence.user.ConfluenceUser;
import com.atlassian.confluence.user.UserAccessor;
import com.atlassian.event.api.EventPublisher;
import com.atlassian.user.User;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.DisposableBean;
import org.springframework.beans.factory.InitializingBean;

public abstract class BaseListener
implements InitializingBean,
DisposableBean {
    private static final Logger logger = LoggerFactory.getLogger(BaseListener.class);
    private final String id;
    private final EventPublisher eventPublisher;
    private final UserAccessor userAccessor;
    private final UserService userService;
    private final BadgeService badgeService;
    private final NotificationService notificationService;
    private final ListenerManager listenerManager;
    private final AccessModeService accessModeService;
    private boolean enabled;

    protected BaseListener(String id, EventPublisher eventPublisher, UserAccessor userAccessor, UserService userService, BadgeService badgeService, NotificationService notificationService, ListenerManager listenerManager, AccessModeService accessModeService) {
        if (id == null) {
            throw new IllegalArgumentException("id can't be null.");
        }
        if (eventPublisher == null) {
            throw new IllegalArgumentException("eventPublisher can't be null.");
        }
        if (userAccessor == null) {
            throw new IllegalArgumentException("userAccessor can't be null.");
        }
        if (userService == null) {
            throw new IllegalArgumentException("userService can't be null.");
        }
        if (badgeService == null) {
            throw new IllegalArgumentException("badgeService can't be null.");
        }
        if (notificationService == null) {
            throw new IllegalArgumentException("notificationService can't be null.");
        }
        if (listenerManager == null) {
            throw new IllegalArgumentException("listenerManager can't be null.");
        }
        if (accessModeService == null) {
            throw new IllegalArgumentException("accessModeService can't be null.");
        }
        this.id = id;
        this.eventPublisher = eventPublisher;
        this.userAccessor = userAccessor;
        this.userService = userService;
        this.badgeService = badgeService;
        this.notificationService = notificationService;
        this.listenerManager = listenerManager;
        this.accessModeService = accessModeService;
    }

    public void afterPropertiesSet() throws Exception {
        if (logger.isDebugEnabled()) {
            logger.debug("Listener '{}' registering at ListenerManager.", (Object)this.id);
        }
        this.listenerManager.register(this);
    }

    public void enable() {
        if (logger.isDebugEnabled()) {
            logger.debug("Listener '{}' enabled.", (Object)this.id);
        }
        this.eventPublisher.register((Object)this);
        this.enabled = true;
    }

    public void disable() {
        if (logger.isDebugEnabled()) {
            logger.debug("Listener '{}' disabled.", (Object)this.id);
        }
        this.eventPublisher.unregister((Object)this);
        this.enabled = false;
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public void destroy() throws Exception {
        if (logger.isDebugEnabled()) {
            logger.debug("Listener '{}' destroyed.", (Object)this.id);
        }
        this.eventPublisher.unregister((Object)this);
        this.enabled = false;
    }

    protected void incrementCountByKey(String userKey, String badgeID) {
        if (this.accessModeService.isReadOnlyAccessModeEnabled()) {
            if (logger.isDebugEnabled()) {
                logger.debug("Read-only mode enabled. Action 'incrementCountByKey' will not be performed.");
            }
            return;
        }
        this.userService.increment(userKey, badgeID);
    }

    protected void incrementCountByName(String username, String badgeID) {
        this.incrementCountByKey(this.userAccessor.getUserByName(username).getKey().getStringValue(), badgeID);
    }

    public final String getId() {
        return this.id;
    }

    protected void checkLevelUpByKey(String userKey, String badgeId) {
        BadgeAO badge;
        if (this.accessModeService.isReadOnlyAccessModeEnabled()) {
            if (logger.isDebugEnabled()) {
                logger.debug("Read-only mode enabled. Action 'checkLevelUpByKey' will not be performed.");
            }
            return;
        }
        int count = this.userService.getCount(userKey, badgeId);
        if (count == (badge = this.badgeService.get(badgeId)).getThresholdBronze() || count == badge.getThresholdSilver() || count == badge.getThresholdGold()) {
            Level level = this.userService.levelUp(userKey, badgeId);
            if (logger.isDebugEnabled()) {
                logger.debug("UserKey: '{}', BadgeId: '{}': LevelUp to level '{}'.", new Object[]{userKey, badgeId, level});
            }
            this.notificationService.levelUp(userKey, badgeId, level);
        } else if (count > badge.getThresholdGold() && count % badge.getThresholdGold() == 0) {
            Level level = this.userService.levelUp(userKey, badgeId);
            if (logger.isDebugEnabled()) {
                logger.debug("UserKey: '{}', BadgeId: '{}': LevelUp to level '{}' (Again).", new Object[]{userKey, badgeId, level});
            }
            this.notificationService.levelUp(userKey, badgeId, level);
        }
    }

    protected void checkLevelUpByName(String username, String badgeId) {
        this.checkLevelUpByKey(this.userAccessor.getUserByName(username).getKey().getStringValue(), badgeId);
    }

    protected boolean checkSameUser(User user, ConfluenceUser confluenceUser) {
        String key1 = this.userAccessor.getUserByName(user.getName()).getKey().getStringValue();
        String key2 = confluenceUser.getKey().getStringValue();
        return key1.equals(key2);
    }
}

