/*
 * Decompiled with CFR 0.152.
 */
package com.agileants.confluence.plugin.badge.common;

import com.agileants.confluence.plugin.badge.utils.Convert;
import com.agileants.confluence.plugin.badge.utils.StringUtils;
import com.atlassian.confluence.api.service.accessmode.AccessModeService;
import com.atlassian.confluence.user.AuthenticatedUserThreadLocal;
import com.atlassian.confluence.user.actions.AbstractUserProfileAction;
import javax.servlet.http.HttpServletRequest;
import org.apache.struts2.ServletActionContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BaseAction
extends AbstractUserProfileAction {
    private static final long serialVersionUID = 6023231673409632758L;
    private static final Logger log = LoggerFactory.getLogger(BaseAction.class);
    private AccessModeService accessModeService;
    private static final String PARAMETER_USERNAME = "username";
    private static final String PARAMETER_PAGE = "page";

    public void setAccessModeService(AccessModeService accessModeService) {
        this.accessModeService = accessModeService;
    }

    public String caps(String value) {
        return StringUtils.capitalizeFirstLetter(value);
    }

    public String getRequestedUsername() {
        String result;
        HttpServletRequest request = ServletActionContext.getRequest();
        String string = result = request == null ? null : request.getParameter(PARAMETER_USERNAME);
        if (result == null) {
            if (log.isDebugEnabled()) {
                log.debug("Username parameter not present, call super..");
            }
            if ((result = super.getUsername()) == null) {
                if (log.isDebugEnabled()) {
                    log.debug("Username parameter not present, use AuthenticatedUserThreadLocal..");
                }
                result = AuthenticatedUserThreadLocal.get().getName();
            }
        }
        if (log.isDebugEnabled()) {
            log.debug(String.format("Username: '%s'.", result));
        }
        return result;
    }

    public int getRequestedPage() {
        HttpServletRequest request = ServletActionContext.getRequest();
        int result = Convert.getInt(request.getParameter(PARAMETER_PAGE), 0);
        if (result < 0) {
            result = 0;
        }
        if (log.isDebugEnabled()) {
            log.debug(String.format("Page: '%d'.", result));
        }
        return result;
    }

    public boolean isReadOnlyMode() {
        return this.accessModeService.isReadOnlyAccessModeEnabled();
    }
}

