/*
 * Decompiled with CFR 0.152.
 */
package com.agileants.confluence.plugin.badge.actions;

import com.agileants.confluence.plugin.badge.activeobjects.RankingAO;
import com.agileants.confluence.plugin.badge.common.BaseAction;
import com.agileants.confluence.plugin.badge.managers.LicenseManager;
import com.agileants.confluence.plugin.badge.objects.dto.UserRankingWithAO;
import com.agileants.confluence.plugin.badge.services.KeyValueService;
import com.agileants.confluence.plugin.badge.services.RankingService;
import com.atlassian.user.User;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ViewUserRanking
extends BaseAction {
    private static final long serialVersionUID = -5207465239041193996L;
    private static final Logger logger = LoggerFactory.getLogger(ViewUserRanking.class);
    private RankingService rankingService;
    private LicenseManager licenseManager;
    private KeyValueService keyValueService;

    public void setRankingService(RankingService rankingService) {
        this.rankingService = rankingService;
    }

    public void setLicenseManager(LicenseManager licenseManager) {
        this.licenseManager = licenseManager;
    }

    public void setKeyValueService(KeyValueService keyValueService) {
        this.keyValueService = keyValueService;
    }

    public boolean checkLicense() {
        return this.licenseManager.checkLicense();
    }

    public UserRankingWithAO getUserRanking() {
        int page;
        List<RankingAO> ranking;
        if (logger.isDebugEnabled()) {
            logger.debug("get user ranking: start..");
        }
        String username = this.getRequestedUsername();
        int requestedPage = this.getRequestedPage();
        if (requestedPage <= 0 || requestedPage > this.getRankingTableLastPage()) {
            ranking = this.rankingService.getRankingByUsername(username);
            page = ranking.size() > 0 ? ranking.get(0).getPage() + 1 : 1;
        } else {
            page = requestedPage;
            ranking = this.rankingService.getRankingByPage(page - 1);
        }
        if (logger.isDebugEnabled()) {
            logger.debug(String.format("UserRanking: username='%s', page='%d'.", username, page));
            logger.debug("get user ranking: DONE.");
        }
        return new UserRankingWithAO(username, page, ranking);
    }

    public int getPaging() {
        return 20;
    }

    public String getRankingTableLastUpdated() {
        long time = Long.parseLong(this.keyValueService.get("ranking.table.last.updated"));
        if (time == 0L) {
            return this.getI18n().getText("badges.not.yet.executed");
        }
        Date date = new Date(time);
        SimpleDateFormat dateFormat = new SimpleDateFormat("EEEEE MMMMM yyyy HH:mm:ss", this.getLocaleManager().getLocale((User)this.getAuthenticatedUser()));
        return dateFormat.format(date);
    }

    public int getRankingTableLastPage() {
        return Integer.parseInt(this.keyValueService.get("ranking.table.last.page")) + 1;
    }
}

