/*
 * Decompiled with CFR 0.152.
 */
package com.agileants.confluence.plugin.badge.actions;

import com.agileants.confluence.plugin.badge.activeobjects.BadgeAO;
import com.agileants.confluence.plugin.badge.activeobjects.UserAO;
import com.agileants.confluence.plugin.badge.common.BaseAction;
import com.agileants.confluence.plugin.badge.enums.Level;
import com.agileants.confluence.plugin.badge.managers.LicenseManager;
import com.agileants.confluence.plugin.badge.objects.dto.MyBadgesPanel;
import com.agileants.confluence.plugin.badge.objects.dto.MyBadgesPanelBadge;
import com.agileants.confluence.plugin.badge.services.BadgeService;
import com.agileants.confluence.plugin.badge.services.RankingService;
import com.agileants.confluence.plugin.badge.services.UserService;
import com.agileants.confluence.plugin.badge.utils.StringUtils;
import com.atlassian.confluence.languages.LocaleManager;
import com.atlassian.confluence.setup.settings.SettingsManager;
import com.atlassian.confluence.user.AuthenticatedUserThreadLocal;
import com.atlassian.confluence.user.ConfluenceUser;
import com.atlassian.confluence.user.UserAccessor;
import com.atlassian.plugin.spring.scanner.annotation.imports.ComponentImport;
import com.atlassian.user.User;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Locale;
import javax.inject.Inject;
import javax.inject.Named;
import org.apache.struts2.ServletActionContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Named
public class ViewMyBadgesPanel
extends BaseAction {
    private static final long serialVersionUID = -6282107975443114007L;
    private static final Logger logger = LoggerFactory.getLogger(ViewMyBadgesPanel.class);
    private static final int RECENT_BADGES_LIMIT = 4;
    private static final String QUESTION_PAGE = "/cq/questions.action";
    private final BadgeService badgeService;
    private final UserService userService;
    private final UserAccessor accessorUser;
    private final LocaleManager localeManager;
    private final LicenseManager licenseManager;
    private final RankingService rankingService;
    @ComponentImport
    private final SettingsManager settingsManager;

    @Inject
    public ViewMyBadgesPanel(BadgeService badgeService, UserService userService, UserAccessor accessorUser, LocaleManager localeManager, LicenseManager licenseManager, RankingService rankingService, SettingsManager settingsManager) {
        this.badgeService = badgeService;
        this.userService = userService;
        this.accessorUser = accessorUser;
        this.localeManager = localeManager;
        this.licenseManager = licenseManager;
        this.rankingService = rankingService;
        this.settingsManager = settingsManager;
    }

    public BadgeService getBadgeService() {
        return this.badgeService;
    }

    public UserService getUserService() {
        return this.userService;
    }

    public boolean checkLicense() {
        return this.licenseManager.checkLicense();
    }

    public MyBadgesPanel loadMyBadges() {
        if (logger.isDebugEnabled()) {
            logger.debug("loadMyBadges: start..");
        }
        MyBadgesPanel myBadgesPanel = new MyBadgesPanel();
        List<UserAO> userAOS = this.userService.allByUser(this.getUserKey());
        if (logger.isDebugEnabled()) {
            logger.debug(String.format("List UserAOS size: %d.", userAOS.size()));
        }
        myBadgesPanel.setRank(this.rankingService.getRank(this.getUserKey()));
        myBadgesPanel.setBadges(ViewMyBadgesPanel.sortBadges(this.getMyBadgesPanelBadgeList(userAOS)));
        myBadgesPanel.setRecentBadges(this.getMyBadgesPanelBadgeList(this.userService.recentByUser(this.getUserKey(), 4)));
        for (UserAO userAO : userAOS) {
            BadgeAO badgeAO = this.badgeService.get(userAO.getBadgeID());
            if (!badgeAO.getEnabled()) continue;
            ViewMyBadgesPanel.calculate(badgeAO, userAO, myBadgesPanel);
        }
        if (logger.isDebugEnabled()) {
            logger.debug(String.format("MyBadgesPanel: %s.", myBadgesPanel.toString()));
        }
        if (logger.isDebugEnabled()) {
            logger.debug("loadMyBadges: DONE.");
        }
        return myBadgesPanel;
    }

    private static void calculate(BadgeAO badgeAO, UserAO userAO, MyBadgesPanel myBadgesPanel) {
        switch (userAO.getLevel()) {
            case BRONZE: {
                myBadgesPanel.incrementBronze();
                break;
            }
            case SILVER: {
                myBadgesPanel.incrementSilver();
                break;
            }
            case GOLD: {
                myBadgesPanel.setGold(myBadgesPanel.getGold() + userAO.getCount() / badgeAO.getThresholdGold());
                break;
            }
            default: {
                if (!logger.isDebugEnabled()) break;
                logger.error(String.format("unknown level: '%s'.", new Object[]{userAO.getLevel()}));
            }
        }
    }

    private List<MyBadgesPanelBadge> getMyBadgesPanelBadgeList(List<UserAO> userAOS) {
        ArrayList<MyBadgesPanelBadge> result = new ArrayList<MyBadgesPanelBadge>();
        for (UserAO userAO : userAOS) {
            BadgeAO badgeAO;
            if (logger.isDebugEnabled()) {
                logger.debug("UserAOS. Index '{}': '{}'.", (Object)userAOS.indexOf(userAO), (Object)StringUtils.userAoToString(userAO));
            }
            if (!(badgeAO = this.badgeService.get(userAO.getBadgeID())).getEnabled()) continue;
            Locale locale = this.localeManager.getLocale((User)AuthenticatedUserThreadLocal.get());
            String name = StringUtils.capitalizeFirstLetter(this.badgeService.getName(badgeAO.getID(), locale));
            String desc = this.badgeService.getDesc(badgeAO.getID(), locale);
            MyBadgesPanelBadge badge = new MyBadgesPanelBadge(name, "", desc, 1, 0, Level.NONE);
            switch (userAO.getLevel()) {
                case BRONZE: {
                    badge.setImage(badgeAO.getBronzeImage());
                    badge.setNext(badgeAO.getThresholdSilver() - userAO.getCount());
                    badge.setLevel(Level.BRONZE);
                    break;
                }
                case SILVER: {
                    badge.setImage(badgeAO.getSilverImage());
                    badge.setNext(badgeAO.getThresholdGold() - userAO.getCount());
                    badge.setLevel(Level.SILVER);
                    break;
                }
                case GOLD: {
                    badge.setImage(badgeAO.getGoldImage());
                    badge.setCount(userAO.getCount() / badgeAO.getThresholdGold());
                    badge.setNext(badgeAO.getThresholdGold() - (userAO.getCount() - badge.getCount() * badgeAO.getThresholdGold()));
                    badge.setLevel(Level.GOLD);
                    break;
                }
            }
            result.add(badge);
            if (!logger.isDebugEnabled()) continue;
            logger.debug("Badge added to result: '{}'.", (Object)badge.toString());
        }
        return result;
    }

    private static List<MyBadgesPanelBadge> sortBadges(List<MyBadgesPanelBadge> badges) {
        Collections.sort(badges, Comparator.comparing(MyBadgesPanelBadge::getLevel, Comparator.reverseOrder()).thenComparing(Comparator.comparingInt(MyBadgesPanelBadge::getCount).reversed()).thenComparing(MyBadgesPanelBadge::getNext).thenComparing(MyBadgesPanelBadge::getName));
        return badges;
    }

    public String getUserKey() {
        String userKey;
        String username = ServletActionContext.getRequest().getParameter("username");
        if (username == null) {
            if (logger.isDebugEnabled()) {
                logger.debug("Username parameter not present.");
            }
            userKey = AuthenticatedUserThreadLocal.get().getKey().getStringValue();
        } else {
            ConfluenceUser user;
            if (logger.isDebugEnabled()) {
                logger.debug("Username parameter present.");
            }
            if ((user = this.accessorUser.getUserByName(username)) == null) {
                if (logger.isDebugEnabled()) {
                    logger.debug("Username '{}' not found.", (Object)username);
                }
                userKey = AuthenticatedUserThreadLocal.get().getKey().getStringValue();
            } else {
                userKey = user.getKey().getStringValue();
            }
        }
        if (logger.isDebugEnabled()) {
            logger.debug("Username: '{}', UserKey: '{}'.", (Object)username, (Object)userKey);
        }
        return userKey;
    }

    public String getContextPath() {
        String contextPath = this.settingsManager.getGlobalSettings().getBaseUrl();
        if (logger.isDebugEnabled()) {
            logger.debug("ContextPath: '{}'.", (Object)contextPath);
        }
        return contextPath;
    }

    public boolean onQuestionsPage() {
        return this.getCurrentRequest().getServletPath().equals(QUESTION_PAGE);
    }
}

