/*
 * Decompiled with CFR 0.152.
 */
package com.agileants.confluence.plugin.badge.actions;

import com.agileants.confluence.plugin.badge.common.BaseAction;
import com.agileants.confluence.plugin.badge.listener.confluence.ConfluenceEventListener;
import com.agileants.confluence.plugin.badge.managers.LicenseManager;
import com.agileants.confluence.plugin.badge.objects.dto.EventRow;
import com.agileants.confluence.plugin.badge.services.EventService;
import com.agileants.confluence.plugin.badge.utils.DateUtils;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ViewEvents
extends BaseAction {
    private static final long serialVersionUID = 2423764560824359565L;
    private static final Logger logger = LoggerFactory.getLogger(ViewEvents.class);
    private EventService eventService;
    private LicenseManager licenseManager;
    private ConfluenceEventListener confluenceEventListener;
    private static final int PAGING = 20;

    public void setEventService(EventService eventService) {
        this.eventService = eventService;
    }

    public void setLicenseManager(LicenseManager licenseManager) {
        this.licenseManager = licenseManager;
    }

    public void setConfluenceEventListener(ConfluenceEventListener confluenceEventListener) {
        this.confluenceEventListener = confluenceEventListener;
    }

    public boolean checkLicense() {
        return this.licenseManager.checkLicense();
    }

    public List<EventRow> getEventsTable(long from, long to, int limit) {
        List<EventRow> result = this.eventService.getEventsTable(from, to, limit);
        if (logger.isDebugEnabled()) {
            logger.debug("List EventRow size: '{}'.", (Object)result.size());
        }
        return result;
    }

    public int getPage() {
        if (logger.isDebugEnabled()) {
            logger.debug("Paging: '{}'.", (Object)20);
        }
        boolean page = true;
        return 1;
    }

    public String todayISO8601() {
        return DateUtils.todayISO8601();
    }

    public long todayInMillis() {
        return DateUtils.todayInMillis();
    }

    public String daysBackISO8601(int days) {
        return DateUtils.daysBackISO8601(days);
    }

    public long daysBackInMillis(int days) {
        return DateUtils.daysBackInMillis(days);
    }

    public int getPaging() {
        return 20;
    }

    public boolean isListenerEnabled() {
        return this.confluenceEventListener.isEnabled();
    }
}

