/*
 * Decompiled with CFR 0.152.
 */
package com.agileants.confluence.plugin.badge.actions;

import com.agileants.confluence.plugin.badge.activeobjects.BadgeAO;
import com.agileants.confluence.plugin.badge.activeobjects.UserAO;
import com.agileants.confluence.plugin.badge.common.BaseAction;
import com.agileants.confluence.plugin.badge.managers.LicenseManager;
import com.agileants.confluence.plugin.badge.objects.dto.AllBadgesRow;
import com.agileants.confluence.plugin.badge.services.BadgeService;
import com.agileants.confluence.plugin.badge.services.UserService;
import com.agileants.confluence.plugin.badge.utils.BadgeUtils;
import com.agileants.confluence.plugin.badge.utils.StringUtils;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ViewAllBadges
extends BaseAction {
    private static final long serialVersionUID = 4221810680349593522L;
    private static final Logger logger = LoggerFactory.getLogger(ViewAllBadges.class);
    private BadgeService badgeService;
    private UserService userService;
    private LicenseManager licenseManager;

    public void setBadgeService(BadgeService badgeService) {
        this.badgeService = badgeService;
    }

    public void setUserService(UserService userService) {
        this.userService = userService;
    }

    public void setLicenseManager(LicenseManager licenseManager) {
        this.licenseManager = licenseManager;
    }

    public boolean checkLicense() {
        return this.licenseManager.checkLicense();
    }

    /*
     * WARNING - void declaration
     */
    public List<AllBadgesRow> getAllBadges() {
        if (logger.isDebugEnabled()) {
            logger.debug("getAllBadges(): start..");
        }
        Map<String, BadgeAO> badges = this.badgeService.allAsMap();
        HashMap<String, AllBadgesRow> rows = new HashMap<String, AllBadgesRow>();
        for (BadgeAO badgeAO : badges.values()) {
            if (!badgeAO.getEnabled()) continue;
            rows.put(badgeAO.getID(), new AllBadgesRow(0, badgeAO.getID(), badgeAO.getNeutralImage(), StringUtils.capitalizeFirstLetter(this.badgeService.getName(badgeAO.getID(), this.getLocale())), 0, 0, 0, 0));
            if (!logger.isDebugEnabled()) continue;
            logger.debug("New row created: '{}'", (Object)((AllBadgesRow)rows.get(badgeAO.getID())).toString());
        }
        List<UserAO> userBadges = this.userService.all();
        for (UserAO userAO : userBadges) {
            BadgeAO badgeAO = badges.get(userAO.getBadgeID());
            if (!badgeAO.getEnabled()) continue;
            AllBadgesRow row = (AllBadgesRow)rows.get(userAO.getBadgeID());
            switch (userAO.getLevel()) {
                case BRONZE: {
                    row.incrementBronzeBadges();
                    break;
                }
                case SILVER: {
                    row.incrementSilverBadges();
                    break;
                }
                case GOLD: {
                    row.setGoldBadges(row.getGoldBadges() + userAO.getCount() / badgeAO.getThresholdGold());
                    break;
                }
            }
            rows.put(userAO.getBadgeID(), row);
            if (!logger.isDebugEnabled()) continue;
            logger.debug("Row updated: '{}'.", (Object)row.toString());
        }
        ArrayList<AllBadgesRow> arrayList = new ArrayList<AllBadgesRow>(rows.values());
        if (logger.isDebugEnabled()) {
            logger.debug("Result list size: '{}'.", (Object)arrayList.size());
        }
        for (AllBadgesRow row : arrayList) {
            row.calculateTotal();
            row.setPoints(BadgeUtils.calculatePoints(row.getBronzeBadges(), row.getSilverBadges(), row.getGoldBadges()));
            if (!logger.isDebugEnabled()) continue;
            logger.debug("Points for badge '{}': '{}'.", (Object)row.getBadgeID(), (Object)row.getPoints());
        }
        Collections.sort(arrayList, Comparator.comparing(AllBadgesRow::getPoints));
        Collections.reverse(arrayList);
        boolean bl = true;
        int preTotal = -1;
        for (AllBadgesRow row : arrayList) {
            void var5_10;
            if (preTotal == row.getTotal()) {
                row.setRank((int)var5_10);
                preTotal = row.getTotal();
            } else if (preTotal == -1) {
                row.setRank((int)var5_10);
                preTotal = row.getTotal();
            } else {
                row.setRank((int)(++var5_10));
                preTotal = row.getTotal();
            }
            if (!logger.isDebugEnabled()) continue;
            logger.debug("Rank for badge '{}': '{}'.", (Object)row.getBadgeID(), (Object)row.getRank());
        }
        if (logger.isDebugEnabled()) {
            logger.debug("getAllBadges(): DONE.");
        }
        return arrayList;
    }
}

