/*
 * Decompiled with CFR 0.152.
 */
package com.agileants.confluence.plugin.badge.actions;

import com.agileants.confluence.plugin.badge.actions.ViewAllBadges;
import com.agileants.confluence.plugin.badge.activeobjects.BadgeAO;
import com.agileants.confluence.plugin.badge.common.BaseAction;
import com.agileants.confluence.plugin.badge.managers.LicenseManager;
import com.agileants.confluence.plugin.badge.objects.dto.MyBadgesPanelBadge;
import com.agileants.confluence.plugin.badge.services.BadgeService;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Locale;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OverviewBadges
extends BaseAction {
    private static final long serialVersionUID = 4598631979798268739L;
    private static final Logger logger = LoggerFactory.getLogger(ViewAllBadges.class);
    private BadgeService badgeService;
    private LicenseManager licenseManager;

    public void setBadgeService(BadgeService badgeService) {
        this.badgeService = badgeService;
    }

    public void setLicenseManager(LicenseManager licenseManager) {
        this.licenseManager = licenseManager;
    }

    public boolean checkLicense() {
        return this.licenseManager.checkLicense();
    }

    public List<MyBadgesPanelBadge> getBadges() {
        ArrayList<MyBadgesPanelBadge> result = new ArrayList<MyBadgesPanelBadge>();
        if (logger.isDebugEnabled()) {
            logger.debug("Result list size: '{}'.", (Object)result.size());
        }
        for (BadgeAO badgeAO : this.badgeService.all()) {
            if (!badgeAO.getEnabled()) continue;
            String id = badgeAO.getID();
            Locale locale = this.getLocale();
            MyBadgesPanelBadge badge = new MyBadgesPanelBadge();
            badge.setName(this.badgeService.getName(id, locale));
            badge.setDescription(this.badgeService.getDesc(id, locale));
            badge.setImage(badgeAO.getNeutralImage());
            result.add(badge);
            if (!logger.isDebugEnabled()) continue;
            logger.debug("Badge added to resut list: '{}'.", (Object)badge.toString());
        }
        if (logger.isDebugEnabled()) {
            logger.debug("Result list size: '{}'.", (Object)result.size());
        }
        Collections.sort(result, Comparator.comparing(MyBadgesPanelBadge::getName));
        return result;
    }
}

