/*
 * Decompiled with CFR 0.152.
 */
package com.agileants.confluence.plugin.badge.actions;

import com.agileants.confluence.plugin.badge.activeobjects.BadgeAO;
import com.agileants.confluence.plugin.badge.common.BaseAction;
import com.agileants.confluence.plugin.badge.managers.LicenseManager;
import com.agileants.confluence.plugin.badge.objects.dto.Badge;
import com.agileants.confluence.plugin.badge.services.BadgeService;
import com.agileants.confluence.plugin.badge.utils.BadgeUtils;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import org.apache.struts2.ServletActionContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GiveBadges
extends BaseAction {
    private static final long serialVersionUID = -451697595532327538L;
    private static final Logger logger = LoggerFactory.getLogger(GiveBadges.class);
    private LicenseManager licenseManager;
    private BadgeService badgeService;

    public void setLicenseManager(LicenseManager licenseManager) {
        this.licenseManager = licenseManager;
    }

    public void setBadgeService(BadgeService badgeService) {
        this.badgeService = badgeService;
    }

    public boolean checkLicense() {
        return this.licenseManager.checkLicense();
    }

    public List<Badge> getBadges() {
        ArrayList<Badge> result = new ArrayList<Badge>();
        List<BadgeAO> badgeAOs = this.badgeService.all();
        if (logger.isDebugEnabled()) {
            logger.debug("BadgeAOs List size: '{}'.", (Object)badgeAOs.size());
        }
        for (BadgeAO badgeAO : badgeAOs) {
            String name = this.badgeService.getName(badgeAO.getID(), this.getLocale());
            String desc = this.badgeService.getDesc(badgeAO.getID(), this.getLocale());
            result.add(new Badge(badgeAO, name, desc));
            if (!logger.isDebugEnabled()) continue;
            logger.debug("Badge added to badges list: '{}'.", (Object)BadgeUtils.badgeAOToString(badgeAO, name, desc));
        }
        if (logger.isDebugEnabled()) {
            logger.debug("Badges List size: '{}'.", (Object)result.size());
        }
        Collections.sort(result, Comparator.comparing(Badge::getName));
        return result;
    }

    public String getBadgeId() {
        String badgeId = ServletActionContext.getRequest().getParameter("badgeId");
        if (logger.isDebugEnabled()) {
            logger.debug("BadgeId Parameter: '{}'.", (Object)badgeId);
        }
        if (badgeId == null) {
            return "null";
        }
        return badgeId;
    }
}

