/*
 * Decompiled with CFR 0.152.
 */
package com.agileants.confluence.plugin.badge.actions;

import com.agileants.confluence.plugin.badge.activeobjects.BadgeAO;
import com.agileants.confluence.plugin.badge.common.BaseAction;
import com.agileants.confluence.plugin.badge.managers.LicenseManager;
import com.agileants.confluence.plugin.badge.objects.dto.Badge;
import com.agileants.confluence.plugin.badge.services.BadgeService;
import com.agileants.confluence.plugin.badge.utils.BadgeUtils;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import org.apache.struts2.ServletActionContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ConfigurePlugin
extends BaseAction {
    private static final long serialVersionUID = -5327488987772060838L;
    private static final Logger logger = LoggerFactory.getLogger(ConfigurePlugin.class);
    private BadgeService badgeService;
    private LicenseManager licenseManager;

    public void setBadgeService(BadgeService badgeService) {
        this.badgeService = badgeService;
    }

    public void setLicenseManager(LicenseManager licenseManager) {
        this.licenseManager = licenseManager;
    }

    public boolean checkLicense() {
        return this.licenseManager.checkLicense();
    }

    public String getBadgeID() {
        String badgeID = ServletActionContext.getRequest().getParameter("badgeID");
        if (logger.isDebugEnabled()) {
            logger.debug("BadgeId Parameter: '{}'.", (Object)badgeID);
        }
        if (badgeID == null) {
            return "null";
        }
        return badgeID;
    }

    public List<Badge> getBadges() {
        ArrayList<Badge> result = new ArrayList<Badge>();
        List<BadgeAO> badgeAOs = this.badgeService.all();
        if (logger.isDebugEnabled()) {
            logger.debug("BadgeAOs List size: '{}'.", (Object)badgeAOs.size());
        }
        for (BadgeAO badgeAO : badgeAOs) {
            String name = this.badgeService.getName(badgeAO.getID(), this.getLocale());
            String desc = this.badgeService.getDesc(badgeAO.getID(), this.getLocale());
            result.add(new Badge(badgeAO, name, desc));
            if (!logger.isDebugEnabled()) continue;
            logger.debug("Badge added to badges list: '{}'.", (Object)BadgeUtils.badgeAOToString(badgeAO, name, desc));
        }
        logger.debug("Badges List size: '{}'.", (Object)result.size());
        Collections.sort(result, Comparator.comparing(Badge::getName));
        return result;
    }
}

