if (typeof Adaptavist == 'undefined') {
    var Adaptavist = {};
}
if (typeof Adaptavist.Forums == 'undefined') {
    Adaptavist.Forums = {};
}
if (typeof Adaptavist.Forums.RestTopicSummary == 'undefined') {
    Adaptavist.Forums.RestTopicSummary = {};
}

AJS.toInit(function ($) {

    var defaultPageSize = 20;
    var prefs = {};

    Adaptavist.Forums.RestTopicSummary.init = function () {
        var rootElement = getJQElement(this);
        var tableElement = rootElement.find('.resttopicsummarytable');
        var paginationElement = rootElement.find('.paginate');
        var pageSize = tableElement.data('page-size');
        pageSize = (isNaN(pageSize) || pageSize <= 0) ? defaultPageSize : pageSize;

        prefs = {
            $element: rootElement,
            $pagination: paginationElement,
            rootPageId: rootElement.attr('data-target-root-page'),
            spaceKey: rootElement.attr('data-target-space-key'),
            $table: tableElement,
            includeSubTopics: rootElement.attr('recurse'),
            tableHeading: rootElement.attr('table-heading'),
            showStatus: rootElement.attr('show-status'),
            sortStickyOnTop: rootElement.attr('sort-sticky-on-top'),
            activityThreshold: rootElement.attr('activity-threshold'),
            showExcerpt: rootElement.attr('show-excerpt'),
            showPics: rootElement.attr('show-pics'),
            showAuthor: rootElement.attr('show-author'),
            showForumLink: rootElement.attr('show-forum-link'),
            bgStyle: tableElement.attr('style')
        };
        prefs.searchCriteria = {
            contentType: 'TOPIC', rootPageId: prefs.rootPageId, spaceKey: prefs.spaceKey,
            recursive: prefs.includeSubTopics, startIndex: 0, pageSize: pageSize,
            options: {sortStickyOnTop: prefs.sortStickyOnTop}
        };
        searchTopics(prefs);
    };

    function searchTopics(prefs) {
        $.ajax({
            type: 'POST',
            url: contextPath + '/rest/forums/latest/search/content',
            data: JSON.stringify(prefs.searchCriteria),
            contentType: 'application/json; charset=utf-8',
            dataType: 'json'
        }).done(function (topicSearchResults) {
            render(topicSearchResults, prefs);
        }).fail(function (response) {
            var title = AJS.I18n.getText("com.adaptavist.confluence.resttopicsummary.resource.error.title");
            error(title, response.responseText, prefs);
        });
    }

    function render(topicSearchResults, prefs) {
        var searchCriteria = prefs.searchCriteria;
        var paginationConfig = Adaptavist.Forums.Commons.PaginationGenerate(topicSearchResults.offset, topicSearchResults.total, searchCriteria.pageSize, 3, 3);
        formatData(topicSearchResults);
        var templateData = {
            topicResults: topicSearchResults, contextPath:
            contextPath, tableHeading: prefs.tableHeading,
            showStatus: prefs.showStatus,
            activityThreshold: prefs.activityThreshold,
            showPics: prefs.showPics,
            showForum: prefs.showForumLink,
            showExcerpt: prefs.showExcerpt,
            showAuthor: prefs.showAuthor,
            bgStyle: prefs.bgStyle
        };
        prefs.$table.html(Adaptavist.Forums.RestTopicSummary.templates.topicsSummary(templateData));
        prefs.$pagination.html(Adaptavist.Forums.Paginate.templates.pagination({config: paginationConfig}));
        prefs.$pagination.find('li a').on('click', function (e) {
            var newIndex = $(this).data('index');
            if (newIndex == 0) {
                newIndex = 1;
            }
            prefs.searchCriteria.startIndex = (newIndex - 1) * searchCriteria.pageSize;
            searchTopics(prefs);
            e.preventDefault();
        });

        if (topicSearchResults.total == 0) {
            var title = AJS.I18n.getText("com.adaptavist.confluence.resttopicsummary.search.no.forums.found.title");
            var body = AJS.I18n.getText("com.adaptavist.confluence.resttopicsummary.search.no.forums.found.body");
            var info = {title: title, body: body};
            $('.restforumMessages', prefs.$element).html(Adaptavist.Forums.RestTopicSummary.templates.info({info: info}));
        } else {
            $('.restforumMessages', prefs.$element).html("");
        }

        // Show the user's details when we are on the user link
        Confluence.Binder.userHover();
    }

    function formatData(topicSearchResults) {
        var topics = topicSearchResults.topics;
        topics.forEach(function (topic) {
            topic.formattedCreationDate = formatDate(topic.creationDate);
            topic.formattedLastReplyDate = formatDate(topic.lastReplyDate);
        });

    }

    function formatDate(date) {
        return moment(Number(date)).fromNow();
    }

    function error(title, message, prefs) {
        var error = {title: title, body: message};
        $('.restforumMessages', prefs.$element).html(Adaptavist.Forums.RestTopicSummary.templates.error({error: error}));
    }

    function getJQElement(elem) {
        return $(elem);
    }

    function initPdfWarningDialog() {
        AJS.InlineDialog(
            $('#action-export-pdf-link'),
            'pdfLink',
            function (content, trigger, showPopup) {
                content
                    .css(
                        {
                            padding: '20px'
                        })
                    .html(
                        '<h2>Please note</h2>' +
                        '<p>Unfortunately, it\'s not currently possible to export a page containing Forums to a pdf using Confluence\'s built in pdf exporter.</p>' +
                        '<p>To get a pdf file of this page, please use your browsers built in "<a target="_blank" href="https://docs.adaptavist.com/x/hYNWBg">Save as pdf</a>" functionality.</p>' +
                        '<p><a target="_blank" href="https://docs.adaptavist.com/x/hYNWBg">Read more</a></p>'
                    );
                showPopup();
                return false;
            }
        );
    }

    $('.resttopicsummary').each(Adaptavist.Forums.RestTopicSummary.init);
});

