/*
 * Decompiled with CFR 0.152.
 */
package com.adaptavist.confluence.forums.servlet.analytic;

import com.atlassian.confluence.security.PermissionManager;
import com.atlassian.confluence.user.AuthenticatedUserThreadLocal;
import com.atlassian.plugin.spring.scanner.annotation.imports.ComponentImport;
import java.io.IOException;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AnalyticsServletFilter
implements Filter {
    private static final Logger LOG = LoggerFactory.getLogger(AnalyticsServletFilter.class);
    private final PermissionManager permissionManager;

    public AnalyticsServletFilter(@ComponentImport PermissionManager permissionManager) {
        this.permissionManager = permissionManager;
    }

    public void doFilter(ServletRequest request, ServletResponse response, FilterChain chain) {
        HttpServletResponse httpServletResponse = (HttpServletResponse)response;
        httpServletResponse.setHeader("Cache-Control", "no-cache, no-store");
        response.setContentType("application/json");
        response.setCharacterEncoding("UTF-8");
        if (this.permissionManager.isConfluenceAdministrator(AuthenticatedUserThreadLocal.get())) {
            try {
                chain.doFilter(request, response);
            }
            catch (IOException | ServletException e) {
                LOG.warn("Confluence was unable to complete processing of the filter chain");
                LOG.debug("Filter Chain failure details", e);
            }
        } else {
            try {
                ((HttpServletResponse)response).sendError(401);
            }
            catch (IOException e) {
                LOG.error("Unable to respond successfully to the client");
                LOG.debug("Servlet response transmission error", (Throwable)e);
            }
            catch (IllegalStateException e) {
                LOG.warn("A response was already sent using this servlets response");
                LOG.debug("Servlet response state error", (Throwable)e);
            }
        }
    }

    public void init(FilterConfig filterConfig) {
    }

    public void destroy() {
    }
}

