/*
 * Decompiled with CFR 0.152.
 */
package com.adaptavist.confluence.forums.service.validation;

import com.atlassian.sal.api.message.I18nResolver;
import java.io.Serializable;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;
import org.apache.commons.lang.ArrayUtils;
import org.apache.commons.lang.StringUtils;

public class ValidationReport {
    private static final ValidationReport SUCCESS = new ValidationReport(ValidationStatus.SUCCESS);
    private final Map<String, Serializable[]> reasons = new LinkedHashMap<String, Serializable[]>();
    private final ValidationStatus status;

    private ValidationReport(ValidationStatus status) {
        this.status = status;
    }

    public static ValidationReport success() {
        return SUCCESS;
    }

    public static ValidationReport failure() {
        return new ValidationReport(ValidationStatus.FAILURE);
    }

    public static ValidationReport combineAll(ValidationReport report1, ValidationReport report2, ValidationReport ... validationReports) {
        ValidationReport validationReport = report1.combinedWith(report2);
        for (ValidationReport report : validationReports) {
            validationReport = validationReport.combinedWith(report);
        }
        return validationReport;
    }

    public boolean isSuccess() {
        return ValidationStatus.SUCCESS.equals((Object)this.status);
    }

    public boolean isFailure() {
        return !this.isSuccess();
    }

    public ValidationReport withReason(String messageKey, Serializable ... args) {
        if (this.isFailure() && StringUtils.isNotBlank((String)messageKey) && !this.reasons.containsKey(messageKey)) {
            this.reasons.put(messageKey, ArrayUtils.isEmpty((Object[])args) ? null : args);
        }
        return this;
    }

    public ValidationReport combinedWith(ValidationReport validationReport) {
        if (validationReport.isFailure() || this.isFailure()) {
            ValidationReport report = new ValidationReport(ValidationStatus.FAILURE);
            report.reasons.putAll(this.getFailures());
            report.reasons.putAll(validationReport.getFailures());
            return report;
        }
        return SUCCESS;
    }

    public String buildResponse(I18nResolver messageResolver) {
        StringBuilder builder = new StringBuilder();
        String separator = ",\n";
        for (String key : this.reasons.keySet()) {
            builder.append(separator);
            if (this.reasons.get(key) != null) {
                builder.append(messageResolver.getText(key, this.reasons.get(key)));
                continue;
            }
            builder.append(messageResolver.getText(key));
        }
        return builder.toString().substring(separator.length());
    }

    public Map<String, Serializable[]> getFailures() {
        return Collections.unmodifiableMap(this.reasons);
    }

    public static enum ValidationStatus {
        SUCCESS,
        FAILURE;

    }
}

