/*
 * Decompiled with CFR 0.152.
 */
package com.adaptavist.confluence.forums.service.search.query.range;

import com.adaptavist.confluence.forums.service.search.query.range.ForumRange;
import org.apache.commons.lang.StringUtils;

public class ForumStringRange
implements ForumRange<String> {
    private static final ForumStringRange EMPTY_RANGE = new ForumStringRange(null, null);
    private final String start;
    private final String end;

    private ForumStringRange(String start, String end) {
        this.start = start;
        this.end = end;
    }

    public static ForumStringRange emptyRange() {
        return EMPTY_RANGE;
    }

    public static ForumStringRange range(String start) {
        return ForumStringRange.range(start, null);
    }

    public static ForumStringRange range(String start, String end) {
        if (ForumStringRange.isEmpty(start, end)) {
            return EMPTY_RANGE;
        }
        return new ForumStringRange(start, end);
    }

    private static boolean isEmpty(String start, String end) {
        return StringUtils.isBlank((String)start) && StringUtils.isBlank((String)end);
    }

    @Override
    public String getStart() {
        return this.start;
    }

    @Override
    public String getEnd() {
        return this.end;
    }

    @Override
    public boolean isEmpty() {
        return ForumStringRange.isEmpty(this.start, this.end);
    }
}

